/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ComponentView
extends View {
    private Component createdC;
    private Component c;

    public ComponentView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        AttributeSet attributeSet = this.getElement().getAttributes();
        Component component = StyleConstants.getComponent(attributeSet);
        return component;
    }

    public float getAlignment(int n) {
        if (this.c != null) {
            switch (n) {
                case 0: {
                    return this.c.getAlignmentX();
                }
                case 1: {
                    return this.c.getAlignmentY();
                }
            }
        }
        return super.getAlignment(n);
    }

    public final Component getComponent() {
        return this.createdC;
    }

    public float getMaximumSpan(int n) {
        if (this.c != null) {
            Dimension dimension = this.c.getMaximumSize();
            switch (n) {
                case 0: {
                    return dimension.width;
                }
                case 1: {
                    return dimension.height;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        return 0.0f;
    }

    public float getMinimumSpan(int n) {
        if (this.c != null) {
            Dimension dimension = this.c.getMinimumSize();
            switch (n) {
                case 0: {
                    return dimension.width;
                }
                case 1: {
                    return dimension.height;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        return 0.0f;
    }

    public float getPreferredSpan(int n) {
        if (this.c != null) {
            Dimension dimension = this.c.getPreferredSize();
            switch (n) {
                case 0: {
                    return dimension.width;
                }
                case 1: {
                    return dimension.height;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }
        return 0.0f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n >= n2 && n <= n3) {
            Rectangle rectangle = shape.getBounds();
            if (n == n3) {
                rectangle.x += rectangle.width;
            }
            rectangle.width = 0;
            return rectangle;
        }
        throw new BadLocationException(String.valueOf(n) + " not in range " + n2 + "," + n3, n);
    }

    public void paint(Graphics graphics, Shape shape) {
        if (this.c != null) {
            this.c.setBounds(shape.getBounds());
            if (!this.c.isVisible()) {
                this.c.setVisible(true);
            }
        }
    }

    void setComponentParent() {
        View view = this.getParent();
        if (view == null) {
            Container container;
            if (this.c != null && (container = this.c.getParent()) != null) {
                container.remove(this.c);
            }
        } else {
            Component component;
            if (this.c == null && (component = this.createComponent()) != null) {
                this.createdC = component;
                this.c = new Invalidator(component);
                this.c.setVisible(false);
            }
            if (this.c != null && this.c.getParent() == null) {
                component = this.getContainer();
                ((Container)component).add(this.c);
            }
        }
    }

    public void setParent(View view) {
        super.setParent(view);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setComponentParent();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    Document document;
                    block5: {
                        document = ComponentView.this.getDocument();
                        try {
                            if (document instanceof AbstractDocument) {
                                ((AbstractDocument)document).readLock();
                            }
                            ComponentView.this.setComponentParent();
                            Container container = ComponentView.this.getContainer();
                            if (container == null) break block5;
                            ComponentView.this.preferenceChanged(null, true, true);
                            container.repaint();
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            if (document instanceof AbstractDocument) {
                                ((AbstractDocument)document).readUnlock();
                            }
                            throw throwable;
                        }
                    }
                    Object var3_3 = null;
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setSize(float f, float f2) {
        if (this.c != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.c.setSize((int)f, (int)f2);
            } else {
                SafeResizer safeResizer = new SafeResizer((int)f, (int)f2);
                SwingUtilities.invokeLater(safeResizer);
            }
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width / 2)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    class SafeResizer
    implements Runnable {
        private int width;
        private int height;

        SafeResizer(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public void run() {
            if (ComponentView.this.c != null) {
                ComponentView.this.c.setSize(this.width, this.height);
            }
        }
    }

    class Invalidator
    extends Container {
        Dimension min;
        Dimension pref;
        Dimension max;
        float yalign;
        float xalign;

        Invalidator(Component component) {
            this.setLayout(new OverlayLayout(this));
            this.add(component);
            this.min = component.getMinimumSize();
            this.pref = component.getPreferredSize();
            this.max = component.getMaximumSize();
            this.yalign = component.getAlignmentY();
            this.xalign = component.getAlignmentX();
        }

        public float getAlignmentX() {
            return this.xalign;
        }

        public float getAlignmentY() {
            return this.yalign;
        }

        public Dimension getMaximumSize() {
            return this.max;
        }

        public Dimension getMinimumSize() {
            return this.min;
        }

        public Dimension getPreferredSize() {
            return this.pref;
        }

        public void invalidate() {
            super.invalidate();
            this.min = super.getMinimumSize();
            this.pref = super.getPreferredSize();
            this.max = super.getMaximumSize();
            this.yalign = super.getAlignmentY();
            this.xalign = super.getAlignmentX();
            if (this.getParent() != null) {
                ComponentView.this.preferenceChanged(null, true, true);
            }
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            Component component = this.getComponent(0);
            component.setVisible(bl);
        }
    }
}

