/*
 * Decompiled with CFR 0.152.
 */
package platform;

import anon.util.RecursiveFileTool;
import java.io.File;
import java.util.Properties;
import logging.LogHolder;
import logging.LogType;
import platform.AbstractOS;

public class LinuxOS
extends AbstractOS {
    private boolean m_bKDE = false;
    private boolean m_bGnome = false;
    public static final String[] BROWSERLIST = new String[]{"firefox", "iexplore", "explorer", "mozilla", "konqueror", "mozilla-firefox", "opera"};

    public LinuxOS() throws Exception {
        String string = System.getProperty("os.name", "").toLowerCase();
        if (string.toLowerCase().indexOf("linux") == -1) {
            throw new Exception("Operating system is not Linux");
        }
        Properties properties = new Properties();
        try {
            properties.load(Runtime.getRuntime().exec("env").getInputStream());
            this.m_bKDE = Boolean.valueOf(properties.getProperty("KDE_FULL_SESSION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_bGnome = properties.getProperty("GNOME_DESKTOP_SESSION_ID") != null;
        this.initEnv("env");
    }

    protected boolean openLink(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_bKDE) {
            try {
                Runtime.getRuntime().exec("kfmclient exec " + string);
                return true;
            }
            catch (Exception exception) {
                LogHolder.log((int)3, (int)LogType.MISC, (String)("Cannot open '" + string + "' in KDE default program."));
            }
        } else if (this.m_bGnome) {
            try {
                Runtime.getRuntime().exec("gnome-open " + string);
                return true;
            }
            catch (Exception exception) {
                LogHolder.log((int)3, (int)LogType.MISC, (String)("Cannot open '" + string + "' in Gnome default program."));
            }
        }
        return false;
    }

    public String getConfigPath(String string) {
        return System.getProperty("user.home", "") + "/.";
    }

    public boolean copyAsRoot(File file, File file2, AbstractOS.AbstractRetryCopyProcess abstractRetryCopyProcess) {
        String string;
        if (file == null || file2 == null || !file2.isDirectory()) {
            return false;
        }
        boolean bl = false;
        String string2 = file.getPath();
        String string3 = file2.getPath() + "/";
        abstractRetryCopyProcess.incrementProgress();
        if (this.m_bKDE) {
            string = "kdesu 'cp -r " + string2 + " " + string3 + "'";
            this.executeShell(string);
        } else if (this.m_bGnome) {
            string = "gksu 'cp -r " + string2 + " " + string3 + "'";
            this.executeShell(string);
        } else {
            string = "xterm -e su -c 'cp -r " + string2 + " " + string3 + "'";
            this.executeShell(string);
            bl = true;
        }
        File file3 = new File(string3 + file.getName());
        if (RecursiveFileTool.equals((File)file3, (File)file, (boolean)true)) {
            while (abstractRetryCopyProcess.incrementProgress()) {
            }
            return true;
        }
        if (bl && abstractRetryCopyProcess != null && abstractRetryCopyProcess.checkRetry()) {
            abstractRetryCopyProcess.reset();
            return this.copyAsRoot(file, file2, abstractRetryCopyProcess);
        }
        return false;
    }

    private void executeShell(String string) {
        try {
            String[] stringArray = new String[]{"sh", "-c", string};
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            process.waitFor();
        }
        catch (Exception exception) {
            LogHolder.log((int)2, (int)LogType.MISC, (Throwable)exception);
        }
    }
}

