/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.IServiceContainer;
import anon.client.AbstractChannel;
import anon.client.MixPacket;
import anon.client.Multiplexer;
import anon.client.TrustException;
import anon.infoservice.MixCascade;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractControlChannel
extends AbstractChannel {
    private IServiceContainer m_serviceContainer;

    public AbstractControlChannel(int n, Multiplexer multiplexer, IServiceContainer iServiceContainer) {
        super(n, multiplexer);
        this.m_serviceContainer = iServiceContainer;
        if (this.m_serviceContainer == null) {
            this.m_serviceContainer = new IServiceContainer(){

                public boolean isTrusted(MixCascade mixCascade) {
                    return true;
                }

                public void checkTrust(MixCascade mixCascade) throws TrustException {
                }

                public void keepCurrentService(boolean bl) {
                }

                public boolean isServiceAutoSwitched() {
                    return false;
                }

                public boolean isReconnectedAutomatically() {
                    return false;
                }
            };
        }
        multiplexer.getChannelTable().registerControlChannel(n, this);
    }

    public int sendRawMessage(byte[] byArray) {
        try {
            int n;
            int n2 = byArray.length;
            do {
                MixPacket mixPacket = this.createEmptyMixPacket();
                n = Math.min(n2, mixPacket.getPayloadData().length);
                mixPacket.setChannelFlags((short)n);
                System.arraycopy(byArray, byArray.length - n2, mixPacket.getPayloadData(), 0, n);
                this.sendPacket(mixPacket);
            } while ((n2 -= n) > 0 && !Thread.currentThread().isInterrupted());
            return 0;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void processReceivedPacket(MixPacket mixPacket) {
        short s = mixPacket.getChannelFlags();
        if (s > mixPacket.getPayloadData().length || s < 0) {
            LogHolder.log(3, LogType.NET, "AbstractControlChannel: processReceivedPacket(): Invalid packet length.");
        } else {
            byte[] byArray = new byte[s];
            System.arraycopy(mixPacket.getPayloadData(), 0, byArray, 0, s);
            this.processPacketData(byArray);
        }
    }

    protected final IServiceContainer getServiceContainer() {
        return this.m_serviceContainer;
    }

    protected abstract void processPacketData(byte[] var1);
}

