/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.ApplicationListener;
import com.skype.Friend;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.Stream;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.Hashtable;
import java.util.Vector;

public final class Application
extends SkypeObject {
    private static final Hashtable applications = new Hashtable();
    private final String name;
    private boolean isInitialized;
    private final Object isInitializedFieldMutex = new Object();
    private Thread shutdownHookForFinish = new ShutdownHookForFinish();
    private final ConnectorListener dataListener = new DataListener();
    private final Object connectMutex = new Object();
    private final Vector listeners = new Vector();
    private final Hashtable streams = new Hashtable();
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Application getInstance(String id) throws SkypeException {
        Application newApplication = new Application(id);
        Application application = null;
        Hashtable hashtable = applications;
        synchronized (hashtable) {
            application = !applications.containsKey(id) ? applications.put(id, newApplication) : (Application)applications.get(id);
        }
        if (application == null) {
            application = newApplication;
        }
        application.initialize();
        return application;
    }

    private Application(String newName) throws SkypeException {
        this.name = newName;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                String response = Connector.getInstance().execute("CREATE APPLICATION " + this.name);
                this.getAllStreams();
                if (response.startsWith("ERROR ") && !response.startsWith("ERROR 541 ")) {
                    Utils.checkError(response);
                }
                if (!this.isInitialized) {
                    Connector.getInstance().addConnectorListener(this.dataListener, false, true);
                    Runtime.getRuntime().addShutdownHook(this.shutdownHookForFinish);
                    this.isInitialized = true;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SkypeException {
        try {
            Object object = this.isInitializedFieldMutex;
            synchronized (object) {
                if (this.isInitialized) {
                    Connector.getInstance().removeConnectorListener(this.dataListener);
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookForFinish);
                    String response = Connector.getInstance().execute("DELETE APPLICATION " + this.getName());
                    Utils.checkError(response);
                    Connector.getInstance().dispose();
                    this.isInitialized = false;
                }
            }
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public Stream[] connect(Friend friends) throws SkypeException {
        Utils.checkNotNull("friends", friends);
        return this.connect(friends.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stream[] connect(final String id) throws SkypeException {
        Utils.checkNotNull("ids", id);
        Object object = this.connectMutex;
        synchronized (object) {
            try {
                final Stream[] wait = new Object();
                AbstractConnectorListener connectorListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.equals("APPLICATION " + Application.this.getName() + " CONNECTING ")) {
                            Object object = wait;
                            synchronized (object) {
                                wait.notify();
                            }
                        } else if (message.startsWith("APPLICATION " + Application.this.getName() + " STREAMS ")) {
                            String streamIds = message.substring(("APPLICATION " + Application.this.getName() + " STREAMS ").length());
                            if ("".equals(streamIds)) {
                                return;
                            }
                            String[] theids = streamIds.split(" ");
                            for (int i = 0; i < theids.length; ++i) {
                                String streamId = theids[i];
                                if (!streamId.startsWith(id + ":")) continue;
                                Object object = wait;
                                synchronized (object) {
                                    wait.notify();
                                    return;
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(connectorListener);
                    Stream[] streamArray = wait;
                    synchronized (wait) {
                        if (id != null) {
                            String command = "ALTER APPLICATION " + this.getName() + " CONNECT " + id;
                            String result = Connector.getInstance().execute(command, new String[]{command, "APPLICATION " + this.getName() + " CONNECTING ", "ERROR "});
                            Utils.checkError(result);
                        }
                        try {
                            wait.wait();
                        }
                        catch (InterruptedException e2) {
                            throw new SkypeException("The connecting was interrupted.", e2);
                        }
                        streamArray = this.getAllStreams(id);
                        return streamArray;
                    }
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                    Stream[] e2 = null;
                    return e2;
                }
                finally {
                    Connector.getInstance().removeConnectorListener(connectorListener);
                }
            }
            catch (SkypeException e) {
                Stream[] streams = this.getAllStreams(id);
                int i = 0;
                while (true) {
                    if (i >= streams.length) {
                        throw e;
                    }
                    Stream stream = streams[i];
                    try {
                        stream.disconnect();
                    }
                    catch (SkypeException e2) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    }

    public Stream[] getAllStreams(String id) throws SkypeException {
        Vector<Stream> results = new Vector<Stream>();
        Stream[] streams = this.getAllStreams();
        for (int i = 0; i < streams.length; ++i) {
            Stream stream = streams[i];
            String comparedId = stream.getFriend().getId();
            if (!comparedId.equals(id)) continue;
            results.add(stream);
        }
        return results.toArray(new Stream[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream[] getAllStreams() throws SkypeException {
        String streamIds = Utils.getPropertyWithCommandId("APPLICATION", this.getName(), "STREAMS");
        Hashtable hashtable = this.streams;
        synchronized (hashtable) {
            this.fireStreamEvents(streamIds);
            if ("".equals(streamIds)) {
                return new Stream[0];
            }
            String[] ids = streamIds.split(" ");
            Stream[] results = new Stream[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                results[i] = (Stream)this.streams.get(ids[i]);
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStreamEvents(String newStreamIdList) {
        Hashtable hashtable = this.streams;
        synchronized (hashtable) {
            String[] newStreamIds = "".equals(newStreamIdList) ? new String[]{} : newStreamIdList.split(" ");
            for (int i = 0; i < newStreamIds.length; ++i) {
                String streamId = newStreamIds[i];
                if (this.streams.containsKey(streamId)) continue;
                Stream stream = new Stream(this, streamId);
                this.streams.put(streamId, stream);
                this.fireConnected(stream);
            }
            String[] oldStreamIds = this.streams.keySet().toArray(new String[0]);
            block4: for (int i = 0; i < oldStreamIds.length; ++i) {
                String oldStreamId = oldStreamIds[i];
                for (int j = 0; j < newStreamIds.length; ++j) {
                    String newStreamId = newStreamIds[j];
                    if (oldStreamId.equals(newStreamId)) continue block4;
                }
                Stream stream = (Stream)this.streams.remove(oldStreamId);
                this.fireDisconnected(stream);
            }
        }
    }

    private void fireConnected(Stream stream) {
        ApplicationListener[] myListeners = this.listeners.toArray(new ApplicationListener[0]);
        for (int i = 0; i < myListeners.length; ++i) {
            ApplicationListener listener = myListeners[i];
            try {
                listener.connected(stream);
                continue;
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    private void fireDisconnected(Stream stream) {
        ApplicationListener[] myListeners = this.listeners.toArray(new ApplicationListener[0]);
        for (int i = 0; i < myListeners.length; ++i) {
            ApplicationListener listener = myListeners[i];
            try {
                listener.disconnected(stream);
                continue;
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public void addApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        Utils.checkNotNull("listener", listener);
        this.listeners.remove(listener);
    }

    private class ShutdownHookForFinish
    extends Thread {
        private ShutdownHookForFinish() {
        }

        public void run() {
            try {
                Connector.getInstance().execute("DELETE APPLICATION " + Application.this.getName());
                Connector.getInstance().dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class DataListener
    extends AbstractConnectorListener {
        private DataListener() {
        }

        public void messageReceived(ConnectorMessageEvent event) {
            String dataHeader;
            String streamsHeader;
            String message = event.getMessage();
            if (message.startsWith(streamsHeader = "APPLICATION " + Application.this.getName() + " STREAMS ")) {
                String streamIds = message.substring(streamsHeader.length());
                Application.this.fireStreamEvents(streamIds);
            }
            if (message.startsWith(dataHeader = "APPLICATION " + Application.this.getName() + " ")) {
                this.handleData(message.substring(dataHeader.length()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleData(String dataResponse) {
            block11: {
                try {
                    if (this.isReceivedText(dataResponse)) {
                        String data = dataResponse.substring("RECEIVED ".length());
                        String streamId = data.substring(0, data.indexOf(61));
                        String dataHeader = "ALTER APPLICATION " + Application.this.getName() + " READ " + streamId;
                        String response = Connector.getInstance().executeWithId(dataHeader, dataHeader);
                        Utils.checkError(response);
                        String text = response.substring(dataHeader.length() + 1);
                        Hashtable hashtable = Application.this.streams;
                        synchronized (hashtable) {
                            if (Application.this.streams.containsKey(streamId)) {
                                ((Stream)Application.this.streams.get(streamId)).fireTextReceived(text);
                            }
                            break block11;
                        }
                    }
                    if (!this.isReceivedDatagram(dataResponse)) break block11;
                    String data = dataResponse.substring("DATAGRAM ".length());
                    String streamId = data.substring(0, data.indexOf(32));
                    String datagram = data.substring(data.indexOf(32) + 1);
                    Hashtable hashtable = Application.this.streams;
                    synchronized (hashtable) {
                        if (Application.this.streams.containsKey(streamId)) {
                            ((Stream)Application.this.streams.get(streamId)).fireDatagramReceived(datagram);
                        }
                    }
                }
                catch (Exception e) {
                    Utils.handleUncaughtException(e, Application.this.exceptionHandler);
                }
            }
        }

        private boolean isReceivedText(String dataResponse) {
            return dataResponse.startsWith("RECEIVED ") && "RECEIVED ".length() < dataResponse.length();
        }

        private boolean isReceivedDatagram(String dataResponse) {
            return dataResponse.startsWith("DATAGRAM ");
        }
    }
}

