/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.proxy.AbstractJonDoFoxHeaders;
import anon.proxy.AnonProxyRequest;
import anon.proxy.HTTPConnectionEvent;
import anon.proxy.HTTPProxyCallback;
import java.util.StringTokenizer;

public final class JonDoFoxHeader
extends AbstractJonDoFoxHeaders {
    public JonDoFoxHeader(int a_priority) {
        super(a_priority);
    }

    public void handleRequest(HTTPConnectionEvent event) {
    }

    public void downstreamContentBytesReceived(HTTPConnectionEvent event) {
    }

    public void requestHeadersReceived(HTTPConnectionEvent event) {
        if (event == null) {
            return;
        }
        HTTPProxyCallback.HTTPConnectionHeader connHeader = event.getConnectionHeader();
        if (connHeader != null) {
            String[] strHeaderValue;
            String[] strReferer;
            String domainReferer;
            if (connHeader.getRequestLine().startsWith("CONNECT")) {
                return;
            }
            if (this.checkJonDoFox(event)) {
                return;
            }
            String domain = connHeader.parseDomain(true);
            if (!(domain == null || (domainReferer = (strReferer = connHeader.getRequestHeader("Referer")) == null || strReferer.length != 1 ? null : HTTPProxyCallback.parseDomain(strReferer[0], true)) != null && domainReferer.equals(domain))) {
                connHeader.removeRequestHeader("Referer");
            }
            if ((strHeaderValue = connHeader.getRequestHeader("Host")) != null && strHeaderValue.length > 0) {
                connHeader.replaceRequestHeader("Host", strHeaderValue[0]);
            }
            connHeader.replaceRequestHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; rv:17.0) Gecko/17.0 Firefox/17.0");
            if (!event.getConnectionHeader().getRequestLine().startsWith("CONNECT")) {
                connHeader.replaceRequestHeader("Accept", "text/html,application/xml,*/*");
                connHeader.replaceRequestHeader("Accept-Language", "en-us");
                String[] clientSupportedencodings = connHeader.getRequestHeader("Accept-Encoding");
                event.getAnonRequest().setInternalEncodingRequired(JonDoFoxHeader.detectInternaEncodingRequired(clientSupportedencodings));
                event.getAnonRequest().setContentEncodings(null);
                connHeader.replaceRequestHeader("Accept-Encoding", "gzip, deflate");
                connHeader.removeRequestHeader("Accept-Charset");
                strHeaderValue = connHeader.getRequestHeader("Referer");
                if (strHeaderValue != null && strHeaderValue.length > 0) {
                    connHeader.replaceRequestHeader("Referer", strHeaderValue[0]);
                }
                connHeader.resetRequestHeader("Connection");
                connHeader.replaceRequestHeader("DNT", "1");
                connHeader.resetRequestHeader("Proxy-Connection");
                connHeader.resetRequestHeader("Keep-Alive");
                connHeader.removeRequestHeader("UA-CPU");
                connHeader.removeRequestHeader("Pragma");
            }
        }
    }

    public void responseHeadersReceived(HTTPConnectionEvent event) {
        AnonProxyRequest req = event.getAnonRequest();
        HTTPProxyCallback.HTTPConnectionHeader connHeader = event.getConnectionHeader();
        if (req.isInternalEncodingRequired()) {
            String[] contentEncodings = connHeader.getResponseHeader("Content-Encoding");
            if (contentEncodings != null) {
                req.setContentEncodings(contentEncodings);
                connHeader.removeResponseHeader("Content-Encoding");
                connHeader.removeResponseHeader("Content-Length");
            } else {
                req.setInternalEncodingRequired(false);
            }
        }
    }

    private static boolean detectInternaEncodingRequired(String[] clientSupportedEncodings) {
        boolean gzipFound = false;
        boolean zlibFound = false;
        if (clientSupportedEncodings != null) {
            StringTokenizer valueTokenizer = null;
            for (int i = 0; i < clientSupportedEncodings.length; ++i) {
                valueTokenizer = new StringTokenizer(clientSupportedEncodings[i], ",");
                String token = null;
                while (valueTokenizer.hasMoreTokens()) {
                    token = valueTokenizer.nextToken().trim();
                    if (!gzipFound) {
                        gzipFound = token.equals("gzip");
                    }
                    if (zlibFound) continue;
                    zlibFound = token.trim().equals("deflate");
                }
            }
        }
        return !gzipFound || !zlibFound;
    }

    public void upstreamContentBytesReceived(HTTPConnectionEvent event) {
    }
}

