/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.message.ExitInformation;
import anon.mixminion.message.Header;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.message.RoutingInformation;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.util.Base64;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class ReplyBlock {
    static final int KEY_LEN = 16;
    static final long KEY_LIFETIME = 7776000L;
    private byte[] m_sharedSecret;
    private Vector m_path;
    private byte[] m_longterm_secret;
    private RoutingInformation m_myrouting;
    private byte[] m_headerbytes;
    private String m_myaddress;
    private long m_timetolive;

    public ReplyBlock(String myaddress, Vector path, byte[] usersecret) {
        this.m_myaddress = myaddress;
        this.m_path = path;
        this.m_longterm_secret = usersecret;
        this.m_myrouting = new RoutingInformation();
        this.m_headerbytes = null;
    }

    public ReplyBlock(RoutingInformation routingInfo, byte[] header, byte[] sharedsecret, long time) {
        this.m_myrouting = routingInfo;
        this.m_headerbytes = header;
        this.m_sharedSecret = sharedsecret;
        this.m_timetolive = time;
    }

    public void buildBlock() {
        byte last;
        System.out.println("Baue ReplyBlock an: " + this.m_myaddress);
        int hops = this.m_path.size();
        byte[] seed = null;
        do {
            seed = MixMinionCryptoUtil.randomArray(20);
            seed[0] = (byte)(seed[0] & 0x7F);
        } while ((last = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(seed, this.m_longterm_secret, "Validate".getBytes()))[19]) != 0);
        byte[] key = ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(seed, this.m_longterm_secret, "Generate".getBytes())), 0, 16);
        byte[] stream = MixMinionCryptoUtil.createPRNG(key, 16 * (hops + 1));
        this.m_sharedSecret = ByteArrayUtil.copy(stream, hops * 16, 16);
        Vector<byte[]> master_secret = new Vector<byte[]>();
        for (int i = 1; i <= hops; ++i) {
            master_secret.addElement(ByteArrayUtil.copy(stream, (hops - i) * 16, 16));
        }
        ExitInformation exitInfo = new ExitInformation();
        String[] destination = new String[]{this.m_myaddress};
        exitInfo = MMRDescription.getExitInformation(destination, seed);
        Header replyHeader = new Header(this.m_path, master_secret, exitInfo);
        this.m_headerbytes = replyHeader.getAsByteArray();
        this.m_myrouting.m_Type = (short)4;
        this.m_myrouting.m_Content = ((MMRDescription)this.m_path.elementAt((int)0)).getRoutingInformation().m_Content;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int day = cal.get(6);
        int year = cal.get(1);
        this.m_timetolive = (long)(((year - 1970 - 1) * 365 + day) * 24 * 60 * 60) + 7776000L;
    }

    public byte[] getHeaderBytes() {
        return this.m_headerbytes;
    }

    public byte[] getSharedSecret() {
        return this.m_sharedSecret;
    }

    public byte[] getReplyBlockasBytes() {
        byte[] beginmarker = new byte[]{83, 85, 82, 66, 1, 0};
        return ByteArrayUtil.conc(beginmarker, ByteArrayUtil.inttobyte(this.m_timetolive, 4), this.m_headerbytes, ByteArrayUtil.inttobyte(this.m_myrouting.m_Content.length, 2), ByteArrayUtil.inttobyte(4L, 2), ByteArrayUtil.conc(this.m_sharedSecret, this.m_myrouting.m_Content));
    }

    public String getReplyBlockasString() {
        return "\n\n:-----BEGIN TYPE III REPLY BLOCK-----\nVERSION: 0.2\n" + Base64.encodeBytes(this.getReplyBlockasBytes()) + "\n:-----END TYPE III REPLY BLOCK-----";
    }

    public RoutingInformation getRouting() {
        return this.m_myrouting;
    }

    public static Vector parseReplyBlocks(String message, byte[] block) throws IOException {
        Vector<ReplyBlock> blocks = new Vector<ReplyBlock>();
        message = message + "\n-----END OF PLAINTEXT MESSAGE-----";
        LineNumberReader reader = new LineNumberReader(new StringReader(message));
        String aktLine = reader.readLine();
        while (true) {
            if (!aktLine.endsWith("-----BEGIN TYPE III REPLY BLOCK-----")) {
                aktLine = reader.readLine();
                if (!aktLine.startsWith("-----END OF PLAINTEXT MESSAGE-----")) continue;
                return blocks;
            }
            if (!reader.readLine().startsWith(">")) {
                aktLine = reader.readLine();
                String myBlock = "";
                while (!aktLine.trim().endsWith("-----END TYPE III REPLY BLOCK-----")) {
                    myBlock = myBlock + aktLine + "\n";
                    aktLine = reader.readLine();
                }
                myBlock = myBlock.substring(0, myBlock.length() - 1);
                byte[] mybyteblock = Base64.decode(myBlock);
                byte[] tl = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    tl[i] = mybyteblock[6 + i];
                }
                long time = ReplyBlock.byteToInt(tl, 0);
                byte[] cs = new byte[]{mybyteblock[2058], mybyteblock[2059]};
                int size = ReplyBlock.byteToInt(cs, 0);
                RoutingInformation rInfo = new RoutingInformation();
                rInfo.m_Type = (short)4;
                byte[] content = new byte[size];
                for (int i = 2078; i < 2078 + size; ++i) {
                    content[i - 2078] = mybyteblock[i];
                }
                rInfo.m_Content = content;
                byte[] h = new byte[2048];
                for (int i = 0; i < 2048; ++i) {
                    h[i] = mybyteblock[i + 10];
                }
                byte[] secret = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    secret[i] = mybyteblock[2062 + i];
                }
                blocks.addElement(new ReplyBlock(rInfo, h, secret, time));
                continue;
            }
            aktLine = reader.readLine();
        }
    }

    public static String removeRepyBlocks(String message) throws IOException {
        LineNumberReader reader = new LineNumberReader(new StringReader(message));
        String aktLine = reader.readLine();
        String myBlock = "";
        boolean rb = false;
        while (aktLine != null) {
            if (aktLine.trim().endsWith("-----BEGIN TYPE III REPLY BLOCK-----")) {
                rb = true;
            }
            if (!rb) {
                myBlock = myBlock + "\n" + aktLine;
            }
            if (aktLine.trim().endsWith("-----END TYPE III REPLY BLOCK-----")) {
                rb = false;
            }
            aktLine = reader.readLine();
        }
        return myBlock;
    }

    public boolean timetoliveIsOK() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int day = cal.get(6);
        int year = cal.get(1);
        long now = ((year - 1970 - 1) * 365 + day) * 24 * 60 * 60;
        return now < this.m_timetolive;
    }

    private static int byteToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }
}

