/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion;

import anon.shared.AbstractAnonChannel;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;

public class MixminionPOPChannel
extends AbstractAnonChannel {
    private int m_state = 0;
    private Vector m_messages = new Vector();
    private String[] m_deleted = null;

    public MixminionPOPChannel() {
        try {
            this.m_deleted = new String[this.m_messages.size()];
            for (int i = 0; i < this.m_messages.size(); ++i) {
                this.m_deleted[i] = (String)this.m_messages.elementAt(i);
            }
            String first = "+OK JAP POP3 server ready\r\n";
            this.toClient(first);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void close_impl() {
    }

    protected void toClient(String message) throws IOException {
        this.recv(message.getBytes(), 0, message.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void send(byte[] buff, int len) throws IOException {
        String s = new String(buff, 0, len);
        if (this.m_state == 0) {
            if (s.toUpperCase().startsWith("USER")) {
                this.m_state = 1;
                this.toClient("+OK\r\n");
                return;
            } else {
                if (!s.toUpperCase().startsWith("AUTH") && !s.toUpperCase().startsWith("CAPA")) throw new RuntimeException("(State=" + this.m_state + ") Didn't understand this Command '" + s + "'");
                this.toClient("-ERR unrecognized\r\n");
            }
            return;
        } else if (this.m_state == 1) {
            if (!s.toUpperCase().startsWith("PASS")) throw new RuntimeException("(State=" + this.m_state + ") Didn't understand this Command '" + s + "'");
            this.m_state = 2;
            this.toClient("+OK\r\n");
            return;
        } else if (this.m_state == 2) {
            if (s.toUpperCase().startsWith("STAT")) {
                int size = 0;
                for (int i = 0; i < this.m_messages.size(); ++i) {
                    size += ((String)this.m_messages.elementAt(i)).getBytes().length;
                }
                this.toClient("+OK " + this.m_messages.size() + " " + size + "\r\n");
                return;
            } else if (s.toUpperCase().startsWith("LIST")) {
                this.m_state = 3;
                this.toClient("+OK " + this.m_messages.size() + " messages" + "\r\n");
                for (int i = 0; i < this.m_messages.size(); ++i) {
                    this.toClient(i + 1 + " " + ((String)this.m_messages.elementAt(i)).getBytes().length + "\r\n");
                }
                this.toClient(".\r\n");
                return;
            } else {
                if (!s.toUpperCase().startsWith("QUIT")) throw new RuntimeException("(State=" + this.m_state + ") Didn't understand this Command '" + s + "'");
                this.toClient("+OK\r\n");
            }
            return;
        } else {
            if (this.m_state != 3) return;
            if (s.startsWith("UIDL") || s.startsWith("XTND")) {
                this.toClient("-ERR unrecognized\r\n");
                return;
            } else if (s.startsWith("TOP")) {
                int id = Integer.parseInt(s.substring(4, 5));
                int lines = 1;
                System.out.println("id: " + id + " lines: " + lines);
                this.toClient("+OK " + ((String)this.m_messages.elementAt(id - 1)).getBytes().length + " octets\r\n");
                LineNumberReader reader = new LineNumberReader(new StringReader((String)this.m_messages.elementAt(id - 1)));
                String aktLine = reader.readLine();
                for (int i = 0; i < 4 + lines || aktLine == null; ++i) {
                    this.toClient(aktLine + "\r\n");
                    aktLine = reader.readLine();
                }
                this.toClient(".\r\n");
                return;
            } else if (s.startsWith("RETR")) {
                int id = 1;
                this.toClient("+OK " + ((String)this.m_messages.elementAt(id - 1)).getBytes().length + " octets\r\n");
                LineNumberReader reader = new LineNumberReader(new StringReader((String)this.m_messages.elementAt(id - 1)));
                String aktLine = reader.readLine();
                while (aktLine != null) {
                    this.toClient(aktLine + "\r\n");
                    aktLine = reader.readLine();
                }
                this.toClient(".\r\n");
                return;
            } else if (s.startsWith("DELE")) {
                int id = 1;
                this.m_deleted[id - 1] = null;
                this.toClient("+OK message " + id + " deleted\r\n");
                return;
            } else {
                if (!s.toUpperCase().startsWith("QUIT")) throw new RuntimeException("(State=" + this.m_state + ") Didn't understand this Command '" + s + "'");
                this.m_messages = new Vector();
                for (int i = 0; i < this.m_deleted.length; ++i) {
                    if (this.m_deleted[i] == null) continue;
                    this.m_messages.addElement(this.m_deleted[i]);
                }
                if (this.m_messages.size() == 0) {
                    this.m_messages = null;
                }
                this.toClient("+OK\r\n");
            }
        }
    }

    public int getOutputBlockSize() {
        return 1000;
    }
}

