/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice.update;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.util.Updater;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractDatabaseUpdater
extends Updater {
    public static final long KEEP_ENTRY_FACTOR = 3L;
    private boolean m_successfulUpdate = false;
    private long m_lLastUpdate = Long.MAX_VALUE;

    public AbstractDatabaseUpdater(long a_updateInterval, Updater.ObservableInfo a_observableInfo) {
        this(new Updater.ConstantUpdateInterval(a_updateInterval), a_observableInfo);
    }

    public AbstractDatabaseUpdater(Updater.IUpdateInterval a_updateInterval, Updater.ObservableInfo a_observableInfo) {
        super(a_updateInterval, a_observableInfo);
    }

    protected void updateInternal() {
        String key;
        Hashtable<String, AbstractDatabaseEntry> hashEntriesNotToUpdate;
        Hashtable hashEntriesToUpdate;
        Hashtable serials = this.getEntrySerials();
        if (Thread.currentThread().isInterrupted()) {
            this.m_successfulUpdate = true;
            return;
        }
        if (serials == null) {
            LogHolder.log(3, LogType.MISC, this.getUpdatedClassName() + "update failed!");
            this.m_successfulUpdate = false;
            return;
        }
        if (serials.size() > 0) {
            hashEntriesToUpdate = new Hashtable(serials.size());
            hashEntriesNotToUpdate = new Hashtable(serials.size());
        } else {
            hashEntriesToUpdate = new Hashtable();
            hashEntriesNotToUpdate = new Hashtable<String, AbstractDatabaseEntry>();
        }
        Enumeration enumSerials = serials.keys();
        while (enumSerials.hasMoreElements()) {
            key = (String)enumSerials.nextElement();
            AbstractDatabaseEntry entry = Database.getInstance(this.getUpdatedClass()).getEntryById(key);
            if (entry != null && ((AbstractDatabaseEntry)serials.get(key)).getVersionNumber() == entry.getVersionNumber()) {
                entry.resetCreationTime();
                hashEntriesNotToUpdate.put(entry.getId(), entry);
                continue;
            }
            hashEntriesToUpdate.put(key, serials.get(key));
        }
        if (Thread.currentThread().isInterrupted()) {
            this.m_successfulUpdate = true;
            return;
        }
        Hashtable newEntries = hashEntriesNotToUpdate.size() == 0 && serials.size() == 0 ? this.getUpdatedEntries(null) : this.getUpdatedEntries(hashEntriesToUpdate);
        if (newEntries != null) {
            Enumeration enumEntriesKept = hashEntriesNotToUpdate.keys();
            while (enumEntriesKept.hasMoreElements()) {
                key = (String)enumEntriesKept.nextElement();
                newEntries.put(key, hashEntriesNotToUpdate.get(key));
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            this.m_successfulUpdate = true;
        } else if (newEntries == null) {
            LogHolder.log(3, LogType.MISC, this.getUpdatedClassName() + "update failed!");
            this.m_successfulUpdate = false;
        } else {
            LogHolder.log(7, LogType.MISC, this.getUpdatedClassName() + "update was successful.");
            boolean updated = false;
            this.m_lLastUpdate = System.currentTimeMillis();
            this.m_successfulUpdate = true;
            Enumeration entries = newEntries.elements();
            while (entries.hasMoreElements()) {
                AbstractDatabaseEntry preferredEntry;
                AbstractDatabaseEntry currentEntry = (AbstractDatabaseEntry)entries.nextElement();
                if (Database.getInstance(this.getUpdatedClass()).update(currentEntry)) {
                    updated = true;
                }
                if ((preferredEntry = this.getPreferredEntry()) == null || !preferredEntry.equals(currentEntry)) continue;
                this.setPreferredEntry(currentEntry);
            }
            if (this.doCleanup(newEntries) || updated) {
                this.getObservableInfo().notifyAdditionalObserversOnUpdate(this.getUpdatedClass());
            }
        }
    }

    protected boolean wasUpdateSuccessful() {
        return this.m_successfulUpdate;
    }

    protected boolean doCleanup(Hashtable a_newEntries) {
        boolean bUpdated = false;
        Enumeration knownDBEntries = Database.getInstance(this.getUpdatedClass()).getEntryList().elements();
        while (knownDBEntries.hasMoreElements()) {
            AbstractDatabaseEntry currentEntry = (AbstractDatabaseEntry)knownDBEntries.nextElement();
            if (this.protectFromCleanup(currentEntry) || currentEntry.isUserDefined() || a_newEntries.contains(currentEntry) || !Database.getInstance(this.getUpdatedClass()).remove(currentEntry)) continue;
            bUpdated = true;
        }
        return bUpdated;
    }

    public final long getLastUpdate() {
        return this.m_lLastUpdate;
    }

    protected boolean protectFromCleanup(AbstractDatabaseEntry a_currentEntry) {
        return false;
    }

    protected AbstractDatabaseEntry getPreferredEntry() {
        return null;
    }

    protected void setPreferredEntry(AbstractDatabaseEntry a_preferredEntry) {
    }

    protected abstract Hashtable getEntrySerials();

    protected abstract Hashtable getUpdatedEntries(Hashtable var1);
}

