/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls;

import anon.crypto.IMyPrivateKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.tinytls.TLSException;
import anon.crypto.tinytls.TLSPlaintextRecord;
import anon.crypto.tinytls.ciphersuites.CipherSuite;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_3DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_AES_128_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_3DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_AES_128_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_DES_CBC_SHA;
import anon.crypto.tinytls.keyexchange.DHE_DSS_Key_Exchange;
import anon.crypto.tinytls.keyexchange.DHE_RSA_Key_Exchange;
import anon.util.ByteArrayUtil;
import anon.util.SocketGuard;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class TinyTLSServerSocket
extends Socket {
    public static byte[] PROTOCOLVERSION = new byte[]{3, 1};
    private static int PROTOCOLVERSION_SHORT = 769;
    private Vector m_supportedciphersuites;
    private CipherSuite m_selectedciphersuite = null;
    private Thread m_threadCloseGuard = null;
    private Object SYNC_CLOSE = new Object();
    private Socket m_Socket;
    private TLSInputStream m_istream;
    private TLSOutputStream m_ostream;
    private boolean m_handshakecompleted;
    private byte[] m_clientrandom;
    private byte[] m_serverrandom;
    private JAPCertificate m_servercertificate;
    private IMyPrivateKey m_privatekey;
    private MyDSAPrivateKey m_DSSKey;
    private MyRSAPrivateKey m_RSAKey;
    private JAPCertificate m_DSSCertificate;
    private JAPCertificate m_RSACertificate;
    private byte[] m_handshakemessages;
    private boolean m_encrypt;

    public InetAddress getInetAddress() {
        return this.m_Socket.getInetAddress();
    }

    public TinyTLSServerSocket(Socket socket) throws IOException {
        this(socket, 0L);
    }

    public TinyTLSServerSocket(Socket socket, final long a_forceCloseAfterMS) throws IOException {
        this.m_Socket = socket;
        if (a_forceCloseAfterMS > 0L) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = TinyTLSServerSocket.this.SYNC_CLOSE;
                    synchronized (object) {
                        if (TinyTLSServerSocket.this.m_threadCloseGuard != null) {
                            try {
                                TinyTLSServerSocket.this.SYNC_CLOSE.wait(a_forceCloseAfterMS);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            if (!SocketGuard.isClosed(TinyTLSServerSocket.this.m_Socket)) {
                                LogHolder.log(1, LogType.NET, "CloseGuard: Closing TLS socket after " + a_forceCloseAfterMS + " milliseconds!");
                                try {
                                    TinyTLSServerSocket.this.close();
                                }
                                catch (IOException ex1) {
                                    LogHolder.log(1, LogType.NET, ex1);
                                }
                            }
                        }
                    }
                }
            };
            this.m_threadCloseGuard = new Thread(run);
            this.m_threadCloseGuard.start();
        }
        this.m_handshakecompleted = false;
        this.m_encrypt = false;
        this.m_supportedciphersuites = new Vector();
        this.m_istream = new TLSInputStream(socket.getInputStream());
        this.m_ostream = new TLSOutputStream(socket.getOutputStream());
        this.m_DSSCertificate = null;
        this.m_DSSKey = null;
        this.m_RSACertificate = null;
        this.m_RSAKey = null;
    }

    public void addCipherSuite(CipherSuite cs) {
        if (!this.m_supportedciphersuites.contains(cs)) {
            if (cs.getKeyExchangeAlgorithm() instanceof DHE_DSS_Key_Exchange && this.m_DSSKey != null && this.m_DSSCertificate != null || cs.getKeyExchangeAlgorithm() instanceof DHE_RSA_Key_Exchange && this.m_RSAKey != null && this.m_RSACertificate != null) {
                this.m_supportedciphersuites.addElement(cs);
            } else {
                LogHolder.log(7, LogType.MISC, "[CIPHERSUITE NOT ADDED] : Please check if you've set the Certificate and the Private Key");
            }
        }
    }

    public void startHandshake() throws IOException {
        if (this.m_supportedciphersuites.isEmpty()) {
            if (this.m_DSSKey != null && this.m_DSSCertificate != null) {
                this.addCipherSuite(new DHE_DSS_WITH_3DES_CBC_SHA());
                this.addCipherSuite(new DHE_DSS_WITH_AES_128_CBC_SHA());
                this.addCipherSuite(new DHE_DSS_WITH_DES_CBC_SHA());
            }
            if (this.m_RSAKey != null && this.m_RSACertificate != null) {
                this.addCipherSuite(new DHE_RSA_WITH_3DES_CBC_SHA());
                this.addCipherSuite(new DHE_RSA_WITH_AES_128_CBC_SHA());
                this.addCipherSuite(new DHE_RSA_WITH_DES_CBC_SHA());
            }
        }
        this.m_handshakemessages = new byte[0];
        try {
            this.m_istream.readClientHello();
            this.m_ostream.sendServerHandshakes();
            this.m_istream.readClientKeyExchange();
            this.m_istream.readClientFinished();
            this.m_ostream.sendChangeCipherSpec();
            this.m_ostream.sendServerFinished();
        }
        catch (TLSException ex) {
            if (ex.Alert()) {
                this.m_ostream.send(21, new byte[]{ex.getAlertLevel(), ex.getAlertDescription()}, 0, 2);
            }
            throw ex;
        }
        this.m_handshakecompleted = true;
    }

    public void setDSSParameters(JAPCertificate cert, MyDSAPrivateKey key) {
        this.m_DSSCertificate = cert;
        this.m_DSSKey = key;
    }

    public void setRSAParameters(JAPCertificate cert, MyRSAPrivateKey key) {
        this.m_RSACertificate = cert;
        this.m_RSAKey = key;
    }

    public InputStream getInputStream() {
        return this.m_istream;
    }

    public OutputStream getOutputStream() {
        return this.m_ostream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException ex;
        block19: {
            block18: {
                block17: {
                    ex = null;
                    try {
                        if (this.m_ostream != null) {
                            this.m_ostream.send(21, new byte[]{1, 0}, 0, 2);
                        }
                    }
                    catch (IOException a_e) {
                        ex = a_e;
                    }
                    try {
                        if (this.m_ostream != null) {
                            this.m_ostream.close();
                        }
                    }
                    catch (IOException a_e) {
                        if (ex != null) break block17;
                        ex = a_e;
                    }
                }
                try {
                    if (this.m_istream != null) {
                        this.m_istream.close();
                    }
                }
                catch (IOException a_e) {
                    if (ex != null) break block18;
                    ex = a_e;
                }
            }
            try {
                if (this.m_Socket != null) {
                    this.m_Socket.close();
                }
            }
            catch (IOException a_e) {
                if (ex != null) break block19;
                ex = a_e;
            }
        }
        if (this.m_threadCloseGuard != null) {
            Object object = this.SYNC_CLOSE;
            synchronized (object) {
                this.SYNC_CLOSE.notify();
                this.m_threadCloseGuard = null;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public boolean isClosed() {
        return SocketGuard.isClosed(this.m_Socket);
    }

    public void setSoTimeout(int ms) throws SocketException {
        if (this.m_Socket != null) {
            this.m_Socket.setSoTimeout(ms);
        }
    }

    static /* synthetic */ byte[] access$302(TinyTLSServerSocket x0, byte[] x1) {
        x0.m_clientrandom = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1102(TinyTLSServerSocket x0, byte[] x1) {
        x0.m_handshakemessages = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1302(TinyTLSServerSocket x0, byte[] x1) {
        x0.m_serverrandom = x1;
        return x1;
    }

    class TLSOutputStream
    extends OutputStream {
        private DataOutputStream m_stream;
        private TLSPlaintextRecord m_aktTLSRecord = new TLSPlaintextRecord();

        public TLSOutputStream(OutputStream ostream) {
            this.m_stream = new DataOutputStream(ostream);
        }

        public void write(byte[] message) throws IOException {
            this.send(23, message, 0, message.length);
        }

        public void write(byte[] message, int offset, int len) throws IOException {
            this.send(23, message, offset, len);
        }

        public void write(int i) throws IOException {
            this.write(new byte[]{(byte)i});
        }

        public void flush() throws IOException {
            this.m_stream.flush();
        }

        private synchronized void send(int type, byte[] message, int offset, int len) throws IOException {
            byte[] dataBuff = this.m_aktTLSRecord.getData();
            System.arraycopy(message, offset, dataBuff, 0, len);
            this.m_aktTLSRecord.setLength(len);
            this.m_aktTLSRecord.setType(type);
            if (TinyTLSServerSocket.this.m_encrypt) {
                TinyTLSServerSocket.this.m_selectedciphersuite.encode(this.m_aktTLSRecord);
            }
            try {
                this.m_stream.write(this.m_aktTLSRecord.getHeader());
            }
            catch (SocketException a_e) {
                throw new TLSException(a_e.getMessage(), 2, 0);
            }
            this.m_stream.write(dataBuff, 0, this.m_aktTLSRecord.getLength());
            this.m_stream.flush();
        }

        public void sendHandshake(int type, byte[] message) throws IOException {
            byte[] senddata = ByteArrayUtil.conc(new byte[]{(byte)type}, ByteArrayUtil.inttobyte(message.length, 3), message);
            this.send(22, senddata, 0, senddata.length);
            TinyTLSServerSocket.access$1102(TinyTLSServerSocket.this, ByteArrayUtil.conc(TinyTLSServerSocket.this.m_handshakemessages, senddata));
        }

        public void sendServerHello() throws IOException {
            byte[] random = new byte[28];
            byte[] sessionid = new byte[]{0};
            byte[] ciphersuite = TinyTLSServerSocket.this.m_selectedciphersuite.getCipherSuiteCode();
            byte[] compression = new byte[]{0};
            byte[] gmt_unix_time = ByteArrayUtil.inttobyte(System.currentTimeMillis() / 1000L, 4);
            Random rand = new Random(System.currentTimeMillis());
            rand.nextBytes(random);
            TinyTLSServerSocket.access$1302(TinyTLSServerSocket.this, ByteArrayUtil.conc(gmt_unix_time, random));
            byte[] message = ByteArrayUtil.conc(PROTOCOLVERSION, TinyTLSServerSocket.this.m_serverrandom, sessionid, ciphersuite, compression);
            this.sendHandshake(2, message);
        }

        public void sendServerCertificate() throws IOException {
            byte[] cert = TinyTLSServerSocket.this.m_servercertificate.toByteArray();
            byte[] length = ByteArrayUtil.inttobyte(cert.length, 3);
            byte[] message = ByteArrayUtil.conc(length, cert);
            length = ByteArrayUtil.inttobyte(message.length, 3);
            message = ByteArrayUtil.conc(length, message);
            this.sendHandshake(11, message);
        }

        public void sendServerKeyExchange() throws IOException {
            this.sendHandshake(12, TinyTLSServerSocket.this.m_selectedciphersuite.getKeyExchangeAlgorithm().generateServerKeyExchange(TinyTLSServerSocket.this.m_privatekey, TinyTLSServerSocket.this.m_clientrandom, TinyTLSServerSocket.this.m_serverrandom));
        }

        public void sendServerHelloDone() throws IOException {
            this.sendHandshake(14, new byte[0]);
        }

        public void sendServerHandshakes() throws IOException {
            this.sendServerHello();
            this.sendServerCertificate();
            this.sendServerKeyExchange();
            this.sendServerHelloDone();
        }

        public void sendChangeCipherSpec() throws IOException {
            TinyTLSServerSocket.this.m_encrypt = false;
            this.send(20, new byte[]{1}, 0, 1);
            TinyTLSServerSocket.this.m_encrypt = true;
        }

        public void sendServerFinished() throws IOException {
            this.sendHandshake(20, TinyTLSServerSocket.this.m_selectedciphersuite.getKeyExchangeAlgorithm().calculateServerFinished(TinyTLSServerSocket.this.m_handshakemessages));
        }
    }

    class TLSInputStream
    extends InputStream {
        private DataInputStream m_stream;
        private int m_aktPendOffset;
        private int m_aktPendLen;
        private TLSPlaintextRecord m_aktTLSRecord = new TLSPlaintextRecord();
        private int m_ReadRecordState;
        private static final int STATE_START = 0;
        private static final int STATE_VERSION = 1;
        private static final int STATE_LENGTH = 2;
        private static final int STATE_PAYLOAD = 3;

        public TLSInputStream(InputStream istream) {
            this.m_stream = new DataInputStream(istream);
            this.m_aktPendOffset = 0;
            this.m_aktPendLen = 0;
            this.m_ReadRecordState = 0;
        }

        private synchronized void readRecord() throws IOException {
            if (this.m_ReadRecordState == 0) {
                byte contenttype;
                try {
                    contenttype = this.m_stream.readByte();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                catch (SocketException a_e) {
                    throw new TLSException(a_e.getMessage(), 2, 0);
                }
                catch (EOFException a_e) {
                    throw new TLSException("EOF", 2, 0);
                }
                if (contenttype < 20 || contenttype > 23) {
                    throw new TLSException("SSL content type protocol not supported: " + contenttype, 2, 10);
                }
                this.m_aktTLSRecord.setType(contenttype);
                this.m_ReadRecordState = 1;
            }
            if (this.m_ReadRecordState == 1) {
                short version;
                try {
                    version = this.m_stream.readShort();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                if (version != PROTOCOLVERSION_SHORT) {
                    throw new TLSException("Protocol version not supported" + version, 2, 70);
                }
                this.m_ReadRecordState = 2;
            }
            if (this.m_ReadRecordState == 2) {
                short length;
                try {
                    length = this.m_stream.readShort();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                if (length < 0) {
                    throw new TLSException("Wrong record len", 2, 70);
                }
                this.m_aktTLSRecord.setLength(length);
                this.m_ReadRecordState = 3;
                this.m_aktPendOffset = 0;
            }
            if (this.m_ReadRecordState == 3) {
                int len = this.m_aktTLSRecord.getLength() - this.m_aktPendOffset;
                byte[] dataBuff = this.m_aktTLSRecord.getData();
                while (len > 0) {
                    try {
                        int ret = this.m_stream.read(dataBuff, this.m_aktPendOffset, len);
                        if (ret < 0) {
                            throw new TLSException("EOF", 2, 0);
                        }
                        len -= ret;
                        this.m_aktPendOffset += ret;
                    }
                    catch (InterruptedIOException ioe) {
                        this.m_aktPendOffset += ioe.bytesTransferred;
                        ioe.bytesTransferred = 0;
                        throw ioe;
                    }
                }
                this.m_ReadRecordState = 0;
                this.m_aktPendOffset = 0;
            }
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) < 1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            block6: while (this.m_aktPendLen < 1) {
                this.readRecord();
                try {
                    switch (this.m_aktTLSRecord.getType()) {
                        case 21: {
                            this.handleAlert();
                        }
                        case 23: {
                            TinyTLSServerSocket.this.m_selectedciphersuite.decode(this.m_aktTLSRecord);
                            this.m_aktPendOffset = 0;
                            this.m_aktPendLen = this.m_aktTLSRecord.getLength();
                            continue block6;
                        }
                    }
                    throw new TLSException("Error while decoding application data", 2, 10);
                }
                catch (Throwable t) {
                    throw new TLSException("Exception by reading next TSL record: " + t.getMessage(), 2, 80);
                }
            }
            int l = Math.min(this.m_aktPendLen, len);
            System.arraycopy(this.m_aktTLSRecord.getData(), this.m_aktPendOffset, b, off, l);
            this.m_aktPendOffset += l;
            this.m_aktPendLen -= l;
            return l;
        }

        public int available() {
            return this.m_aktPendLen;
        }

        private void handleAlert() throws IOException {
            LogHolder.log(7, LogType.MISC, "[TLS] ALERT!");
            if (TinyTLSServerSocket.this.m_handshakecompleted) {
                TinyTLSServerSocket.this.m_selectedciphersuite.decode(this.m_aktTLSRecord);
            }
            byte[] payload = this.m_aktTLSRecord.getData();
            block0 : switch (payload[0]) {
                case 1: {
                    switch (payload[1]) {
                        case 0: {
                            LogHolder.log(7, LogType.MISC, "[RECIEVED-ALERT] TYPE=WARNING ; MESSAGE=CLOSE NOTIFY");
                            break block0;
                        }
                    }
                    throw new TLSException("TLSAlert detected!! Level : Warning - Description :" + payload[1]);
                }
                case 2: {
                    throw new TLSException("TLSAlert detected!! Level : Fatal - Description :" + payload[1]);
                }
                default: {
                    throw new TLSException("Unknown TLSAlert detected!!");
                }
            }
        }

        public void readClientHello() throws IOException {
            this.readRecord();
            byte[] dataBuff = this.m_aktTLSRecord.getData();
            if (this.m_aktTLSRecord.getType() == 22 && dataBuff[0] == 1) {
                if ((dataBuff[4] << 8 | dataBuff[5]) == PROTOCOLVERSION_SHORT) {
                    TinyTLSServerSocket.access$302(TinyTLSServerSocket.this, new byte[32]);
                    System.arraycopy(dataBuff, 6, TinyTLSServerSocket.this.m_clientrandom, 0, 32);
                    if (dataBuff[38] != 0) {
                        throw new TLSException("Client wants to reuse another session, but this is not supportet yet", 2, 40);
                    }
                    try {
                        int aktpos;
                        int cslength = (dataBuff[39] & 0xFF) << 8 | dataBuff[40] & 0xFF;
                        block2: for (aktpos = 41; cslength + 41 > aktpos && TinyTLSServerSocket.this.m_selectedciphersuite == null; aktpos += 2) {
                            for (int i = 0; i < TinyTLSServerSocket.this.m_supportedciphersuites.size(); ++i) {
                                CipherSuite cs = (CipherSuite)TinyTLSServerSocket.this.m_supportedciphersuites.elementAt(i);
                                byte[] b = cs.getCipherSuiteCode();
                                if (dataBuff[aktpos] != b[0] || dataBuff[aktpos + 1] != b[1]) continue;
                                TinyTLSServerSocket.this.m_selectedciphersuite = cs;
                                if (cs.getKeyExchangeAlgorithm() instanceof DHE_DSS_Key_Exchange) {
                                    TinyTLSServerSocket.this.m_servercertificate = TinyTLSServerSocket.this.m_DSSCertificate;
                                    TinyTLSServerSocket.this.m_privatekey = TinyTLSServerSocket.this.m_DSSKey;
                                    continue block2;
                                }
                                if (cs.getKeyExchangeAlgorithm() instanceof DHE_RSA_Key_Exchange) {
                                    TinyTLSServerSocket.this.m_servercertificate = TinyTLSServerSocket.this.m_RSACertificate;
                                    TinyTLSServerSocket.this.m_privatekey = TinyTLSServerSocket.this.m_RSAKey;
                                    continue block2;
                                }
                                LogHolder.log(7, LogType.MISC, "[ERROR!!!] : KeyExchangeAlgorithm not supported yet.(should never happen)");
                                continue block2;
                            }
                        }
                        if (TinyTLSServerSocket.this.m_selectedciphersuite == null) {
                            throw new TLSException("no supported ciphersuite found", 2, 40);
                        }
                        aktpos = cslength + 41;
                        int complength = dataBuff[aktpos];
                        if (complength == 0) {
                            throw new TLSException("no compressionalgorithm defined. you need at least one (for example no_compression)", 2, 50);
                        }
                        while (complength != 0) {
                            if (dataBuff[++aktpos] == 0) {
                                TinyTLSServerSocket.access$1102(TinyTLSServerSocket.this, ByteArrayUtil.conc(TinyTLSServerSocket.this.m_handshakemessages, dataBuff, this.m_aktTLSRecord.getLength()));
                                return;
                            }
                            --complength;
                        }
                        throw new TLSException("no supportet compressionalgorithm found", 2, 40);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        throw new TLSException("client hello is not long enough", 2, 50);
                    }
                }
                throw new TLSException("this Protocol is not supported", 2, 70);
            }
            throw new TLSException("Client hello expected but another message was received", 2, 10);
        }

        public void readClientKeyExchange() throws IOException {
            this.readRecord();
            byte[] dataBuff = this.m_aktTLSRecord.getData();
            try {
                if (dataBuff[0] == 16) {
                    int length = (dataBuff[4] & 0xFF) << 8 | dataBuff[5];
                    byte[] publickey = ByteArrayUtil.copy(dataBuff, 6, this.m_aktTLSRecord.getLength() - 6);
                    publickey = ByteArrayUtil.conc(new byte[]{0}, publickey);
                    BigInteger dh_y = new BigInteger(publickey);
                    TinyTLSServerSocket.this.m_selectedciphersuite.processClientKeyExchange(dh_y);
                    TinyTLSServerSocket.access$1102(TinyTLSServerSocket.this, ByteArrayUtil.conc(TinyTLSServerSocket.this.m_handshakemessages, dataBuff, this.m_aktTLSRecord.getLength()));
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new TLSException(ex.getLocalizedMessage(), 2, 50);
            }
            throw new TLSException("Client Key Exchange expected, but another messagetype was recieved", 2, 10);
        }

        public void readClientFinished() throws IOException {
            this.readRecord();
            byte[] dataBuff = this.m_aktTLSRecord.getData();
            if (this.m_aktTLSRecord.getType() != 20 || this.m_aktTLSRecord.getLength() != 1 || dataBuff[0] != 1) {
                throw new TLSException("Change Cipher Spec expected", 2, 10);
            }
            TinyTLSServerSocket.this.m_encrypt = true;
            this.readRecord();
            TinyTLSServerSocket.this.m_selectedciphersuite.decode(this.m_aktTLSRecord);
            try {
                if (dataBuff[0] == 20) {
                    byte[] verify_data = ByteArrayUtil.copy(dataBuff, 4, 12);
                    TinyTLSServerSocket.this.m_selectedciphersuite.getKeyExchangeAlgorithm().processClientFinished(verify_data, TinyTLSServerSocket.this.m_handshakemessages);
                    TinyTLSServerSocket.access$1102(TinyTLSServerSocket.this, ByteArrayUtil.conc(TinyTLSServerSocket.this.m_handshakemessages, dataBuff, this.m_aktTLSRecord.getLength()));
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new TLSException(ex.getLocalizedMessage(), 2, 50);
            }
            throw new TLSException("Client Finish message expected, but another message was recieved", 2, 10);
        }
    }
}

