/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509KeyIdentifier;
import anon.crypto.ByteSignature;
import anon.crypto.IMyPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;

public final class X509SubjectKeyIdentifier
extends AbstractX509KeyIdentifier {
    public static final String IDENTIFIER = Extension.subjectKeyIdentifier.getId();

    public X509SubjectKeyIdentifier(IMyPublicKey a_publicKey) {
        super(IDENTIFIER, X509SubjectKeyIdentifier.createDEROctets(a_publicKey));
        this.createValue();
    }

    public X509SubjectKeyIdentifier(ASN1Sequence a_extension) {
        super(a_extension);
        this.createValue();
    }

    public String getName() {
        return "SubjectKeyIdentifier";
    }

    private static byte[] createDEROctets(IMyPublicKey a_publicKey) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DEROutputStream derout = new DEROutputStream(out);
            SubjectPublicKeyInfo pubKeyInfo = a_publicKey.getAsSubjectPublicKeyInfo();
            byte[] digest = X509SubjectKeyIdentifier.getDigest(pubKeyInfo);
            SubjectKeyIdentifier keyId = new SubjectKeyIdentifier(digest);
            derout.writeObject(keyId.toASN1Primitive());
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not write DER object to bytes!");
        }
        return out.toByteArray();
    }

    private void createValue() {
        byte[] identifier;
        try {
            ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets()));
            identifier = ((DEROctetString)ais.readObject()).getOctets();
            ais.close();
        }
        catch (Exception a_e) {
            throw new RuntimeException("Could not read subject key identifier from byte array!");
        }
        this.m_value = ByteSignature.toHexString(identifier);
    }

    public static byte[] getDigest(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] buff = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(buff, 0);
        return buff;
    }
}

