/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import anon.infoservice.ListenerInterface;
import anon.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public abstract class AbstractX509AlternativeName
extends AbstractX509Extension {
    public static final Integer TAG_OTHER = new Integer(0);
    public static final Integer TAG_EMAIL = new Integer(1);
    public static final Integer TAG_DNS = new Integer(2);
    public static final Integer TAG_URL = new Integer(6);
    public static final Integer TAG_IP = new Integer(7);
    public static final String OTHER_NAME = "otherName";
    public static final String RFC_822_NAME = "rfc822Name";
    public static final String DNS_NAME = "dNSName";
    public static final String X400_ADDRESS = "x400Address";
    public static final String DIRECTORY_NAME = "directoryName";
    public static final String EDI_PARTY_NAME = "ediPartyName";
    public static final String UNIFORM_RESOURCE_IDENTIFIER = "uniformResourceIdentifier";
    public static final String IP_ADDRESS = "iPAddress";
    public static final String REGISTERED_ID = "registeredID";
    private Vector m_values;
    private Vector m_tags;

    public AbstractX509AlternativeName(String a_identifier, String a_value, Integer a_tag) {
        this(a_identifier, Util.toVector(a_value), Util.toVector(a_tag));
    }

    public AbstractX509AlternativeName(String a_identifier, boolean a_critical, String a_value, Integer a_tag) {
        this(a_identifier, a_critical, Util.toVector(a_value), Util.toVector(a_tag));
    }

    public AbstractX509AlternativeName(String a_identifier, Vector a_values, Vector a_tags) {
        this(a_identifier, false, a_values, a_tags);
    }

    public AbstractX509AlternativeName(String a_identifier, boolean a_critical, Vector a_values, Vector a_tags) {
        super(a_identifier, a_critical, AbstractX509AlternativeName.createValue(a_values, a_tags));
        this.m_values = (Vector)a_values.clone();
        this.m_tags = (Vector)a_tags.clone();
    }

    public AbstractX509AlternativeName(ASN1Sequence a_extension) {
        super(a_extension);
        ASN1Sequence values;
        this.m_values = new Vector();
        this.m_tags = new Vector();
        try {
            ASN1InputStream ais = new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets()));
            values = (ASN1Sequence)ais.readObject();
            ais.close();
        }
        catch (IOException a_e) {
            a_e.printStackTrace();
            throw new RuntimeException("Could not read object from DER sequence!");
        }
        Enumeration enumValues = values.getObjects();
        while (enumValues.hasMoreElements()) {
            ASN1TaggedObject taggedValue = (ASN1TaggedObject)enumValues.nextElement();
            Integer tag = new Integer(taggedValue.getTagNo());
            byte[] value = ((ASN1OctetString)taggedValue.getObject()).getOctets();
            if (tag.equals(TAG_IP)) {
                String ipaddress = new String(value);
                if (!AbstractX509AlternativeName.isValidIP(ipaddress)) {
                    for (int i = 0; i < value.length; ++i) {
                        ipaddress = ipaddress + (value[i] & 0xFF);
                        if (i + 1 >= value.length) continue;
                        ipaddress = ipaddress + ".";
                    }
                }
                this.m_values.addElement(ipaddress);
            } else {
                this.m_values.addElement(new String(value));
            }
            this.m_tags.addElement(tag);
        }
    }

    public static boolean isValidIP(String a_ipAddress) {
        return ListenerInterface.isValidIP(a_ipAddress);
    }

    public static boolean isValidEMail(String a_email) {
        if (a_email == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(a_email, ",");
        if (!tokenizer.hasMoreElements()) {
            return false;
        }
        while (tokenizer.hasMoreElements()) {
            String email = tokenizer.nextToken().trim();
            if (email.length() == 0) {
                return false;
            }
            int dot = email.lastIndexOf(46);
            int len = email.length();
            int at = email.indexOf(64);
            if (len == 0 || at == -1 || dot == -1 || at == 0 || dot < at) {
                return false;
            }
            if (dot + 2 < len) continue;
            return false;
        }
        return true;
    }

    public Vector getValues() {
        return (Vector)this.m_values.clone();
    }

    public Vector getTags() {
        return (Vector)this.m_tags.clone();
    }

    private static byte[] createValue(Vector a_values, Vector a_tags) {
        byte[] value = null;
        ASN1EncodableVector values = new ASN1EncodableVector();
        if (a_values != null && a_values.size() != 0) {
            int i;
            if (a_tags == null || a_values.size() != a_tags.size()) {
                throw new IllegalArgumentException("Tags have an invalid size!");
            }
            Vector tempTags = new Vector();
            Vector<String> tempValues = new Vector<String>();
            for (i = 0; i < a_values.size(); ++i) {
                if (!(a_values.elementAt(i) instanceof String)) {
                    throw new IllegalArgumentException("Values must be Strings!");
                }
                StringTokenizer tokenizer = new StringTokenizer((String)a_values.elementAt(i), ",");
                while (tokenizer.hasMoreTokens()) {
                    tempTags.addElement(a_tags.elementAt(i));
                    tempValues.addElement(tokenizer.nextToken().trim());
                }
            }
            a_tags = tempTags;
            a_values = tempValues;
            for (i = 0; i < a_values.size(); ++i) {
                String strValue = (String)a_values.elementAt(i);
                if (strValue == null || strValue.length() == 0) continue;
                if (a_tags.elementAt(i) == null || !(a_tags.elementAt(i) instanceof Integer)) {
                    throw new IllegalArgumentException("Unsupported tag: " + a_tags.elementAt(i));
                }
                Integer tag = (Integer)a_tags.elementAt(i);
                if (tag.equals(TAG_IP)) {
                    if (!AbstractX509AlternativeName.isValidIP(strValue)) {
                        throw new IllegalArgumentException("Invalid IP address: " + strValue);
                    }
                } else if (tag.equals(TAG_EMAIL)) {
                    if (!AbstractX509AlternativeName.isValidEMail(strValue)) {
                        throw new IllegalArgumentException("Invalid email address: " + strValue);
                    }
                } else if (tag.equals(TAG_URL)) {
                    try {
                        new URL(strValue);
                    }
                    catch (Exception a_e) {
                        throw new IllegalArgumentException(a_e.getMessage());
                    }
                } else if (!tag.equals(TAG_DNS) && !tag.equals(TAG_OTHER)) {
                    throw new IllegalArgumentException("Unsupported tag: " + tag);
                }
                if (value == null) {
                    value = strValue.getBytes();
                }
                values.add(new DERTaggedObject(tag, new DEROctetString(value)));
                value = null;
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new DEROutputStream(out).writeObject(new DERSequence(values));
        }
        catch (IOException a_e) {
            throw new RuntimeException("Error while writing object to byte array.");
        }
        return out.toByteArray();
    }

    public static String getTagAsString(int tagNo) {
        switch (tagNo) {
            case 0: {
                return OTHER_NAME;
            }
            case 1: {
                return RFC_822_NAME;
            }
            case 2: {
                return DNS_NAME;
            }
            case 3: {
                return X400_ADDRESS;
            }
            case 4: {
                return DIRECTORY_NAME;
            }
            case 5: {
                return EDI_PARTY_NAME;
            }
            case 6: {
                return UNIFORM_RESOURCE_IDENTIFIER;
            }
            case 7: {
                return IP_ADDRESS;
            }
            case 8: {
                return REGISTERED_ID;
            }
        }
        return null;
    }
}

