/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class SocketContainer {
    private Socket m_socket;
    private InputStream m_alternativeInputStream;
    private OutputStream m_alternativeOutputStream;

    public SocketContainer(Socket a_socket, InputStream a_alternativeInputStream, OutputStream a_alternativeOutputStream) {
        this.m_alternativeInputStream = a_alternativeInputStream;
        this.m_alternativeOutputStream = a_alternativeOutputStream;
        if (a_socket == null) {
            throw new NullPointerException("SocketContainer: Constructor: Socket must not be null.");
        }
        this.m_socket = a_socket;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        inputStream = this.m_alternativeInputStream != null ? this.m_alternativeInputStream : this.m_socket.getInputStream();
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = null;
        outputStream = this.m_alternativeOutputStream != null ? this.m_alternativeOutputStream : this.m_socket.getOutputStream();
        return outputStream;
    }

    public void close() throws IOException {
        this.m_socket.close();
    }

    public void setSocketTimeout(int a_timeout) throws SocketException {
        this.m_socket.setSoTimeout(a_timeout);
    }

    public SocketContainer createChildContainer(InputStream a_alternativeInputStream, OutputStream a_alternativeOutputStream) throws IOException {
        InputStream inputStream = null;
        inputStream = a_alternativeInputStream == null ? this.getInputStream() : a_alternativeInputStream;
        OutputStream outputStream = null;
        outputStream = a_alternativeOutputStream == null ? this.getOutputStream() : a_alternativeOutputStream;
        return new SocketContainer(this.m_socket, inputStream, outputStream);
    }
}

