/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class LimitedLengthInputStream
extends InputStream {
    private InputStream m_underlyingStream;
    private long m_readLimit;

    public LimitedLengthInputStream(InputStream a_underlyingStream, long a_maximumLength) {
        if (a_underlyingStream == null) {
            throw new NullPointerException("LimitedLengthInputStream: Constructor: The underlying stream must not be null!");
        }
        this.m_underlyingStream = a_underlyingStream;
        this.m_readLimit = a_maximumLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int returnByte = -1;
        if (this.m_readLimit == -1L) {
            returnByte = this.m_underlyingStream.read();
        } else {
            LimitedLengthInputStream limitedLengthInputStream = this;
            synchronized (limitedLengthInputStream) {
                if (this.m_readLimit > 0L && (returnByte = this.m_underlyingStream.read()) != -1) {
                    --this.m_readLimit;
                }
            }
        }
        return returnByte;
    }

    @Override
    public int read(byte[] a_buffer) throws IOException {
        return this.read(a_buffer, 0, a_buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] a_buffer, int a_offset, int a_length) throws IOException {
        int bytesRead = 0;
        if (this.m_readLimit == -1L) {
            bytesRead = this.m_underlyingStream.read(a_buffer, a_offset, a_length);
        } else {
            LimitedLengthInputStream limitedLengthInputStream = this;
            synchronized (limitedLengthInputStream) {
                if (this.m_readLimit > 0L) {
                    int bytesToRead = a_length;
                    if ((long)a_length > this.m_readLimit) {
                        bytesToRead = (int)this.m_readLimit;
                    }
                    try {
                        bytesRead = this.m_underlyingStream.read(a_buffer, a_offset, bytesToRead);
                    }
                    catch (InterruptedIOException e) {
                        this.m_readLimit -= (long)e.bytesTransferred;
                        throw e;
                    }
                    if (bytesRead != -1) {
                        this.m_readLimit -= (long)bytesRead;
                    }
                } else if (a_length > 0) {
                    bytesRead = -1;
                }
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        int availableBytes = 0;
        if (this.m_readLimit == -1L) {
            availableBytes = this.m_underlyingStream.available();
        } else {
            LimitedLengthInputStream limitedLengthInputStream = this;
            synchronized (limitedLengthInputStream) {
                if (this.m_readLimit > 0L && (long)(availableBytes = this.m_underlyingStream.available()) > this.m_readLimit) {
                    availableBytes = (int)this.m_readLimit;
                }
            }
        }
        return availableBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.m_underlyingStream.close();
        LimitedLengthInputStream limitedLengthInputStream = this;
        synchronized (limitedLengthInputStream) {
            this.m_readLimit = 0L;
        }
    }

    public synchronized long getRemainingBytes() {
        return this.m_readLimit;
    }
}

