/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos.integration;

import anon.util.Util;
import infoservice.agreement.paxos.IPaxosTarget;
import infoservice.agreement.paxos.PaxosAcceptor;
import infoservice.agreement.paxos.PaxosExecution;
import infoservice.agreement.paxos.PaxosInstance;
import infoservice.agreement.paxos.integration.Commitment;
import infoservice.agreement.paxos.integration.CommitmentScheme;
import infoservice.agreement.paxos.integration.InfoServicePaxosInstance;
import infoservice.agreement.paxos.messages.PaxosMessage;
import infoservice.dynamic.DynamicConfiguration;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public abstract class PaxosAdapter
extends PaxosAcceptor {
    private static final int STATE_INACTIVE = 0;
    private static final int STATE_PASSIVE = 1;
    private static final int STATE_COMMITMENT = 2;
    private static final int STATE_PHASE_GAP = 3;
    private static final int STATE_REVEAL = 4;
    protected Hashtable m_commitments;
    protected Commitment m_ownCommitment;
    protected Vector m_passivelyReceivedMessages = new Vector();
    protected Vector m_potentialyCorrectMessage = new Vector();
    AgreementStarterThread m_starterThread = new AgreementStarterThread();
    protected int m_currentState = 0;

    protected abstract void prepareTargets();

    protected PaxosAdapter() {
        this.m_starterThread.start();
    }

    public void startProtocolByOperator() {
        if (this.m_currentState > 1) {
            this.info("Won't start agreement, there is one running atm");
            return;
        }
        if (this.m_currentState == 1) {
            this.info("Won't start agreement, I am already passive and an agreement will start soon");
            return;
        }
        if (this.m_currentState == 0) {
            if (this.m_starterThread != null) {
                this.m_starterThread.cancel();
            }
            this.info("Initializing agreement");
            this.startPassivePhase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAgreement() {
        this.info("Starting Agreement");
        this.m_currentState = 2;
        this.prepareTargets();
        this.startRound();
        String proposal = Long.toString(new SecureRandom().nextLong());
        this.m_ownCommitment = CommitmentScheme.createCommitment(proposal);
        this.propose(this.m_ownCommitment.getCommitmentAsString());
        Vector vector = this.m_passivelyReceivedMessages;
        synchronized (vector) {
            this.info("Will now handle " + this.m_passivelyReceivedMessages.size() + " passively received messages");
            Enumeration en = this.m_passivelyReceivedMessages.elements();
            int i = 1;
            while (en.hasMoreElements()) {
                PaxosMessage msg = (PaxosMessage)en.nextElement();
                this.debug("Now handling passively received " + msg.getMessageType() + "-message from " + msg.getSender() + " (" + i + ")");
                this.handleIncommingMessage(msg);
                ++i;
            }
            this.m_passivelyReceivedMessages.clear();
        }
    }

    public void startRound() {
        InfoServicePaxosInstance instance = new InfoServicePaxosInstance(this, this.m_lastRandom);
        Vector roundLeaders = this.getRoundLeaders();
        Enumeration en2 = roundLeaders.elements();
        while (en2.hasMoreElements()) {
            String leader = (String)en2.nextElement();
            IPaxosTarget tmp = (IPaxosTarget)this.m_targets.get(leader);
            PaxosExecution result = new PaxosExecution(instance, tmp.getId(), roundLeaders);
            instance.getExecutions().put(tmp.getId(), result);
        }
        this.m_paxosInstances.put(this.m_lastRandom, instance);
    }

    protected boolean roundNrAcceptable(PaxosMessage a_msg) {
        String r1 = Util.replaceAll(this.m_lastRandom, "--r", "");
        String r2 = r1 + "--r";
        return a_msg.getPaxosInstanceIdentifier().equals(r1) || a_msg.getPaxosInstanceIdentifier().equals(r2);
    }

    protected boolean senderNotInSnapshot(PaxosMessage a_msg) {
        return !this.m_targets.containsKey(a_msg.getSender());
    }

    protected void sendReject(PaxosMessage a_msg) {
        if (a_msg.getSender().equals(this.getIdentifier())) {
            return;
        }
        PaxosMessage reject = new PaxosMessage(PaxosMessage.REJECT);
        reject.setInitiator(a_msg.getInitiator());
        reject.setSender(this.getIdentifier());
        reject.setProposal(Util.replaceAll(this.m_lastRandom, "--r", ""));
        reject.setPaxosInstanceIdentifier(a_msg.getPaxosInstanceIdentifier());
        reject.setRound(a_msg.getRound());
        IPaxosTarget tmp = (IPaxosTarget)this.m_targets.get(a_msg.getSender());
        this.sendMessage(reject, tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncommingMessage(final PaxosMessage a_msg) {
        if (this.m_currentState == 0) {
            this.debug("Inactive! Not handling the message");
            return;
        }
        if (this.m_currentState == 1 || this.m_currentState == 3) {
            Vector vector = this.m_passivelyReceivedMessages;
            synchronized (vector) {
                this.m_passivelyReceivedMessages.add(a_msg);
            }
            this.debug("Passive or PhaseGap! Queueing a " + a_msg.getMessageType() + "-message from " + a_msg.getSender() + ", have now " + this.m_passivelyReceivedMessages.size());
            return;
        }
        if (a_msg.getMessageType().equals(PaxosMessage.REJECT)) {
            InfoServicePaxosInstance inst = (InfoServicePaxosInstance)this.m_paxosInstances.get(a_msg.getPaxosInstanceIdentifier());
            inst.handleRejectMessage(a_msg);
            return;
        }
        if (this.senderNotInSnapshot(a_msg)) {
            this.debug("Sender not in Snapshop: " + a_msg.getSender());
            return;
        }
        if (!this.roundNrAcceptable(a_msg)) {
            if (this.m_currentState == 2 && a_msg.getMessageType().equals(PaxosMessage.PROPOSE)) {
                this.sendReject(a_msg);
            }
            this.debug("Round number not acceptable: " + a_msg.getPaxosInstanceIdentifier());
            Vector vector = this.m_potentialyCorrectMessage;
            synchronized (vector) {
                this.m_potentialyCorrectMessage.add(a_msg);
            }
            return;
        }
        new Thread(){

            @Override
            public void run() {
                PaxosAdapter.this.handleMessage(a_msg);
            }
        }.start();
    }

    public synchronized void handleMessage(PaxosMessage a_msg) {
        this.addMessage(a_msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReject(String a_newRound) {
        if (this.m_lastRandom.equals(a_newRound)) {
            return;
        }
        PaxosInstance old = (PaxosInstance)this.m_paxosInstances.get(this.m_lastRandom);
        if (old != null) {
            Enumeration en = old.getExecutions().keys();
            while (en.hasMoreElements()) {
                PaxosExecution ex = (PaxosExecution)old.getExecutions().get(en.nextElement());
                ex.cancel();
            }
        }
        if (a_newRound == null) {
            this.babylonianConfusion();
        }
        this.info(this.getIdentifier() + ": REJECT SUCCESSFUL, STARTING ROUND WITH: MY " + a_newRound + ", OLD WAS " + this.m_lastRandom);
        this.m_lastRandom = a_newRound;
        this.startRound();
        String proposal = Long.toString(new SecureRandom().nextLong());
        this.m_ownCommitment = CommitmentScheme.createCommitment(proposal);
        this.propose(this.m_ownCommitment.getCommitmentAsString());
        Vector vector = this.m_potentialyCorrectMessage;
        synchronized (vector) {
            this.debug("Will now handle " + this.m_potentialyCorrectMessage.size() + " ex-rejected messages");
            Enumeration en = this.m_potentialyCorrectMessage.elements();
            int i = 1;
            while (en.hasMoreElements()) {
                PaxosMessage msg = (PaxosMessage)en.nextElement();
                this.handleIncommingMessage(msg);
                ++i;
            }
            this.m_potentialyCorrectMessage.clear();
        }
    }

    private void babylonianConfusion() {
        this.fatal("BABYLONIAN CONFUSION");
        this.m_lastRandom = "0000000000";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyAgreement(Hashtable a_agreements) {
        Vector vector = this.m_potentialyCorrectMessage;
        synchronized (vector) {
            this.m_potentialyCorrectMessage.clear();
        }
        if (this.m_currentState == 2) {
            this.m_currentState = 3;
            this.info("Done with commitment phase...waiting for others");
            this.m_commitments = a_agreements;
            this.m_lastRandom = this.m_lastRandom + "--r";
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(DynamicConfiguration.getInstance().getAgreementPhaseGap());
                    }
                    catch (InterruptedException e) {
                        PaxosAdapter.this.error("Unable to wait between commitment phase and reveal phase: " + e.toString());
                    }
                    PaxosAdapter.this.info("Starting reveal phase");
                    PaxosAdapter.this.m_currentState = 4;
                    PaxosAdapter.this.startRound();
                    PaxosAdapter.this.propose(PaxosAdapter.this.m_ownCommitment.getRevealAsString());
                    Vector vector = PaxosAdapter.this.m_passivelyReceivedMessages;
                    synchronized (vector) {
                        PaxosAdapter.this.debug("Will now handle " + PaxosAdapter.this.m_passivelyReceivedMessages.size() + " passively received messages");
                        Enumeration en = PaxosAdapter.this.m_passivelyReceivedMessages.elements();
                        int i = 1;
                        while (en.hasMoreElements()) {
                            PaxosMessage msg = (PaxosMessage)en.nextElement();
                            PaxosAdapter.this.debug("Now handling passively received " + msg.getMessageType() + "-message from " + msg.getSender() + " (" + i + ")");
                            PaxosAdapter.this.handleIncommingMessage(msg);
                            ++i;
                        }
                        PaxosAdapter.this.m_passivelyReceivedMessages.clear();
                    }
                }
            }.start();
            return;
        }
        Enumeration en = a_agreements.keys();
        long agreement = 0L;
        int count = 0;
        while (en.hasMoreElements()) {
            String is = en.nextElement().toString();
            if (a_agreements.get(is).equals("NULL")) {
                this.debug("Agreement for " + is + " is NULL");
                continue;
            }
            String reveal = a_agreements.get(is).toString();
            if (CommitmentScheme.verifyCommitment(this.m_commitments.get(is).toString(), reveal)) {
                String proposal = reveal.split("#")[1];
                agreement += Long.parseLong(proposal);
                this.info("Agreement for " + is + ": " + Long.parseLong(proposal));
                ++count;
                continue;
            }
            this.debug("ARGS, the reveal " + reveal + " from " + is + " doesn't match its commitment");
        }
        this.info("Agreement  : " + agreement);
        final boolean needRestart = "0000000000".equals(Util.replaceAll(this.m_lastRandom, "--r", ""));
        if (!needRestart) {
            if (count < this.getQuorumTwoThird()) {
                this.info("To few infoservices participated in the value, won't use it");
                return;
            }
            this.useAgreement(agreement);
        } else {
            this.info("Need restart, old LCR was the default one!");
        }
        final long tmp = agreement;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(DynamicConfiguration.getInstance().getAgreementPhaseGap());
                }
                catch (InterruptedException e) {
                    PaxosAdapter.this.error("Unable to sleep in thread");
                }
                PaxosAdapter.this.m_lastRandom = Long.toString(tmp);
                if (needRestart) {
                    PaxosAdapter.this.startPassivePhase();
                    return;
                }
                PaxosAdapter.this.m_currentState = 0;
                PaxosAdapter.this.m_starterThread = new AgreementStarterThread();
                PaxosAdapter.this.m_starterThread.start();
                PaxosAdapter.this.info("Ready to start a new agreement");
            }
        }.start();
    }

    public void startPassivePhase() {
        this.info("Starting passive phase");
        this.m_currentState = 1;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(DynamicConfiguration.getInstance().getPassivePhaseLength());
                }
                catch (InterruptedException e) {
                    LogHolder.log(3, LogType.AGREEMENT, "Unable to wait for passive phase interval", e);
                }
                PaxosAdapter.this.startAgreement();
            }
        }.start();
    }

    protected abstract void useAgreement(long var1);

    class AgreementStarterThread
    extends Thread {
        private boolean m_canceled = false;

        AgreementStarterThread() {
        }

        @Override
        public void run() {
            while (!this.timeForAgreement()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LogHolder.log(3, LogType.AGREEMENT, "Unable to wait for agreement polling interval", e);
                }
                if (!this.m_canceled) continue;
                return;
            }
            PaxosAdapter.this.startPassivePhase();
        }

        public void cancel() {
            this.m_canceled = true;
        }

        private boolean timeForAgreement() {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("CET"));
            int hour = DynamicConfiguration.getInstance().getHourOfAgreement();
            return c.get(12) % hour == 0;
        }
    }
}

