/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos;

import infoservice.agreement.common.TimeoutListener;
import infoservice.agreement.paxos.PaxosExecution;
import infoservice.agreement.paxos.PaxosInstance;
import infoservice.agreement.paxos.PaxosProposer;
import infoservice.agreement.paxos.PaxosRound;
import infoservice.agreement.paxos.messages.CollectMessage;
import infoservice.agreement.paxos.messages.FreezeProofMessage;
import infoservice.agreement.paxos.messages.PaxosMessage;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class PaxosAcceptor
extends PaxosProposer
implements TimeoutListener {
    protected Hashtable m_paxosInstances = new Hashtable();

    public void addMessage(PaxosMessage a_msg) {
        if (a_msg.getMessageType().equals(PaxosMessage.PROPOSE)) {
            this.addProposeMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.WEAK)) {
            this.addWeakMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.STRONG)) {
            this.addStrongMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.DECIDE)) {
            this.addDecideMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.FREEZE)) {
            this.addFreezeMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.FREEZEPROOF)) {
            this.addFreezeProofMessage(a_msg);
        } else if (a_msg.getMessageType().equals(PaxosMessage.COLLECT)) {
            this.addCollectMessage(a_msg);
        }
    }

    private void addCollectMessage(PaxosMessage a_msg) {
        this.info("Add collect message from: " + a_msg.getSender() + " with proposal: " + a_msg.getProposal());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addCollectMessage((CollectMessage)a_msg)) {
            if (round.isGood(a_msg.getProposal())) {
                this.weakAccept(round, a_msg);
            } else {
                this.error(a_msg.getSender() + " proposed " + a_msg.getProposal() + " which is not GOOD!");
            }
        }
    }

    private void addFreezeProofMessage(PaxosMessage a_msg) {
        int oldRound = a_msg.getRound();
        PaxosExecution exec = this.getPaxosInstance(a_msg.getPaxosInstanceIdentifier()).getExecution(a_msg);
        PaxosRound round = exec.getRound(oldRound + 1);
        this.info("Received FreezeProof from " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        if (round == null) {
            round = exec.createRound(oldRound + 1);
        }
        if (round.getLeaderId().equals(exec.getPaxosInstance().getAcceptor().getIdentifier()) && round.addProof((FreezeProofMessage)a_msg)) {
            if (round.getFreezeProofMessageCount() > 2 * this.getF()) {
                this.debug("That are enough FreezeProofs, sending COLLECT");
                String good = round.getExecution().getGoodProposal(round.getRoundNumber());
                CollectMessage msg = new CollectMessage();
                msg.setInitiator(exec.getInitiator());
                msg.setPaxosInstanceIdentifier(a_msg.getPaxosInstanceIdentifier());
                msg.setProposal(good);
                msg.setProofs(round.getFreezeProofs());
                msg.setSender(this.getIdentifier());
                msg.setRound(oldRound);
                this.multicast(msg);
            } else {
                this.debug("Not enough proves yet: need " + (2 * this.getF() + 1) + ", have " + round.getFreezeProofMessageCount());
            }
        }
    }

    private void addFreezeMessage(PaxosMessage a_msg) {
        this.info("Adding freeze message from: " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addFreezeMessage(a_msg)) {
            if (round.getFreezeMessageCount() > this.getF() && !round.isFrozen()) {
                this.freeze(round);
            }
            if (round.getFreezeMessageCount() > 2 * this.getF() && round.isFrozen() && !round.isAborted()) {
                round.abort();
                FreezeProofMessage msg = new FreezeProofMessage();
                this.cloneMessage(a_msg, msg);
                msg.setWeakValue(round.getWeakAccepted());
                msg.setStrongValue(round.getStrongAccepted());
                PaxosRound next = round.getExecution().createRound(a_msg.getRound() + 1);
                this.sendMessage(next.getLeaderId(), msg);
            }
        }
    }

    private void addProposeMessage(PaxosMessage a_msg) {
        this.debug("Proposal received from: " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addProposal(a_msg) && !round.isWeakAccepted()) {
            this.weakAccept(round, a_msg);
        }
    }

    private void addWeakMessage(PaxosMessage a_msg) {
        this.debug("Weak message received from: " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addWeakMessage(a_msg)) {
            if (round.getWeakMessageCount(a_msg.getProposal()) > this.getQuorumDecideWeak() && !round.getExecution().isDecided()) {
                this.decide(round, a_msg, true);
            }
            if (round.getWeakMessageCount(a_msg.getProposal()) > this.getQuorumStrong() && !round.isStrongAccepted()) {
                this.strongAccept(round, a_msg);
            }
            if (round.getWeakMessageCount(a_msg.getProposal()) > this.getF() && !round.isWeakAccepted()) {
                this.weakAccept(round, a_msg);
            }
        }
    }

    private void addStrongMessage(PaxosMessage a_msg) {
        this.debug("Strong message received from: " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addStrongMessage(a_msg) && round.getStrongMessageCount(a_msg.getProposal()) > this.getQuorumDecideStrong() && !round.getExecution().isDecided()) {
            this.decide(round, a_msg, true);
        }
    }

    private void addDecideMessage(PaxosMessage a_msg) {
        this.debug("Decide message received from: " + a_msg.getSender() + " for " + a_msg.getInitiator() + ", Round: " + a_msg.getRound());
        PaxosRound round = this.getPaxosRound(a_msg);
        if (round == null) {
            return;
        }
        if (round.addDecideMessage(a_msg) && round.getDecideMessageCount(a_msg.getProposal()) > this.getF() && !round.getExecution().isDecided()) {
            this.decide(round, a_msg, true);
        }
    }

    private void weakAccept(PaxosRound a_round, PaxosMessage a_msg) {
        a_round.weakAccept(a_msg.getProposal());
        PaxosMessage msg = new PaxosMessage(PaxosMessage.WEAK);
        this.cloneMessage(a_msg, msg);
        this.multicast(msg);
    }

    private void cloneMessage(PaxosMessage a_original, PaxosMessage a_target) {
        a_target.setInitiator(a_original.getInitiator());
        a_target.setSender(this.getIdentifier());
        a_target.setProposal(a_original.getProposal());
        a_target.setRound(a_original.getRound());
        a_target.setPaxosInstanceIdentifier(a_original.getPaxosInstanceIdentifier());
    }

    private void strongAccept(PaxosRound a_round, PaxosMessage a_msg) {
        a_round.weakAccept(a_msg.getProposal());
        PaxosMessage msg = new PaxosMessage(PaxosMessage.STRONG);
        this.cloneMessage(a_msg, msg);
        this.multicast(msg);
    }

    private void decide(PaxosRound a_round, PaxosMessage a_msg, boolean a_sendDecide) {
        this.info("DECIDED ON " + a_msg.getProposal() + " FOR " + a_msg.getInitiator());
        a_round.decide(a_msg.getProposal());
        a_round.getExecution().decide(a_msg.getProposal());
        if (a_sendDecide) {
            PaxosMessage msg = new PaxosMessage(PaxosMessage.DECIDE);
            this.cloneMessage(a_msg, msg);
            this.multicast(msg);
        }
    }

    private void freeze(PaxosRound a_round) {
        this.info("FROZEN ROUND " + a_round.getRoundNumber() + " FOR " + a_round.getExecution().getInitiator());
        a_round.freeze();
        PaxosMessage msg = new PaxosMessage(PaxosMessage.FREEZE);
        msg.setInitiator(a_round.getExecution().getInitiator());
        msg.setSender(this.getIdentifier());
        msg.setRound(a_round.getRoundNumber());
        msg.setPaxosInstanceIdentifier(a_round.getExecution().getPaxosInstance().getInstanceNumber());
        this.multicast(msg);
    }

    @Override
    public void timeout(Object m_round) {
        PaxosRound round = (PaxosRound)m_round;
        if (round.getExecution().isDecided() || round.isFrozen()) {
            return;
        }
        this.freeze(round);
    }

    public PaxosInstance getPaxosInstance(String a_paxosInstanceId) {
        return (PaxosInstance)this.m_paxosInstances.get(a_paxosInstanceId);
    }

    private PaxosRound getPaxosRound(PaxosMessage a_msg) {
        PaxosInstance inst = this.getPaxosInstance(a_msg.getPaxosInstanceIdentifier());
        if (inst == null) {
            this.error("PaxosInstance is for " + a_msg.getPaxosInstanceIdentifier() + " is NULL, how can that be?");
            return null;
        }
        PaxosRound result = inst.getExecution(a_msg).getRound(a_msg.getRound());
        if (result == null) {
            result = inst.getExecution(a_msg).createRound(a_msg.getRound());
        }
        return result;
    }

    protected Vector getRoundLeaders() {
        Vector<String> roundLeaders = new Vector<String>();
        Enumeration en = this.m_targets.keys();
        while (en.hasMoreElements()) {
            String leader = (String)en.nextElement();
            roundLeaders.add(leader);
        }
        Collections.sort(roundLeaders);
        return roundLeaders;
    }

    protected abstract void notifyAgreement(Hashtable var1);
}

