/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.StatusInfo;

public class StatusStatisticsEntry {
    private String m_mixCascadeId;
    private int m_minNrOfActiveUsers;
    private int m_maxNrOfActiveUsers;
    private int m_nrOfActiveUsersSum;
    private long m_mixedPackets;
    private int m_userStatisticsUpdates;
    private long m_timeInLastStatisticsMessage;

    public StatusStatisticsEntry(StatusInfo a_currentStatus) {
        this.m_mixCascadeId = a_currentStatus.getId();
        this.m_nrOfActiveUsersSum = a_currentStatus.getNrOfActiveUsers();
        this.m_minNrOfActiveUsers = a_currentStatus.getNrOfActiveUsers();
        this.m_maxNrOfActiveUsers = a_currentStatus.getNrOfActiveUsers();
        this.m_mixedPackets = a_currentStatus.getMixedPackets();
        this.m_userStatisticsUpdates = 1;
        this.m_timeInLastStatisticsMessage = a_currentStatus.getVersionNumber();
    }

    public void updateStatistics(StatusInfo a_currentStatus) {
        if (a_currentStatus.getVersionNumber() > this.m_timeInLastStatisticsMessage) {
            this.m_timeInLastStatisticsMessage = a_currentStatus.getVersionNumber();
            if (a_currentStatus.getNrOfActiveUsers() > -1) {
                if (this.m_minNrOfActiveUsers == -1 || a_currentStatus.getNrOfActiveUsers() < this.m_minNrOfActiveUsers) {
                    this.m_minNrOfActiveUsers = a_currentStatus.getNrOfActiveUsers();
                }
                if (this.m_maxNrOfActiveUsers == -1 || a_currentStatus.getNrOfActiveUsers() > this.m_maxNrOfActiveUsers) {
                    this.m_maxNrOfActiveUsers = a_currentStatus.getNrOfActiveUsers();
                }
                this.m_nrOfActiveUsersSum = this.m_nrOfActiveUsersSum != -1 ? (this.m_nrOfActiveUsersSum += a_currentStatus.getNrOfActiveUsers()) : a_currentStatus.getNrOfActiveUsers();
                ++this.m_userStatisticsUpdates;
            }
            this.m_mixedPackets = a_currentStatus.getMixedPackets();
        }
    }

    public String getId() {
        return this.m_mixCascadeId;
    }

    public String getLogString() {
        return Integer.toString(this.m_minNrOfActiveUsers) + "," + Integer.toString(this.m_maxNrOfActiveUsers) + "," + Integer.toString(Math.round((float)this.m_nrOfActiveUsersSum / (float)this.m_userStatisticsUpdates)) + "," + Long.toString(this.m_mixedPackets);
    }

    public String getFileName() {
        char[] fileName = this.m_mixCascadeId.toCharArray();
        for (int i = 0; i < fileName.length; ++i) {
            if (Character.isLetterOrDigit(fileName[i])) continue;
            fileName[i] = 95;
        }
        return "logStatus" + new String(fileName) + ".log";
    }
}

