/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceIDEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.ServiceSoftware;
import anon.pay.PaymentInstanceDBEntry;
import infoservice.Configuration;
import infoservice.InfoServiceDistributor;
import infoservice.performance.PerformanceMeter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class InfoServicePropagandist
implements Runnable {
    private static long ms_serialNumber;
    private static boolean alreadyRunning;
    private static PerformanceMeter m_meter;

    public static void generateInfoServicePropagandist(PerformanceMeter a_meter) {
        if (!alreadyRunning) {
            alreadyRunning = true;
            m_meter = a_meter;
            ms_serialNumber = System.currentTimeMillis();
            InfoServicePropagandist propaganda = new InfoServicePropagandist();
            Thread propagandist = new Thread((Runnable)propaganda, "Propaganda Thread");
            propagandist.start();
        }
    }

    @Override
    public void run() {
        boolean bInit = true;
        while (true) {
            Vector<ListenerInterface> virtualListeners;
            if ((virtualListeners = Configuration.getInstance().getVirtualListeners()).size() > 0) {
                for (int i = 0; i < 4 && (i != 1 || bInit); ++i) {
                    Enumeration enumTmp;
                    AbstractDatabaseEntry tmpEntry;
                    Hashtable<String, AbstractDatabaseEntry> hashEntries = new Hashtable<String, AbstractDatabaseEntry>();
                    Enumeration enumNeighbours = Database.getInstance(InfoServiceDBEntry.class).getEntrySnapshotAsEnumeration();
                    while (enumNeighbours.hasMoreElements()) {
                        try {
                            tmpEntry = (AbstractDatabaseEntry)enumNeighbours.nextElement();
                            if (tmpEntry.getId().equals(Configuration.getInstance().getID())) continue;
                            enumTmp = i == 0 ? ((InfoServiceDBEntry)tmpEntry).getInfoServices(false).elements() : (i == 1 ? ((InfoServiceDBEntry)tmpEntry).getPaymentInstances(false).elements() : (i == 2 ? ((InfoServiceDBEntry)tmpEntry).getMixCascades(false).elements() : ((InfoServiceDBEntry)tmpEntry).getMixes(false).elements()));
                        }
                        catch (Exception a_e) {
                            enumTmp = new Hashtable().elements();
                        }
                        while (enumTmp.hasMoreElements()) {
                            tmpEntry = (AbstractDatabaseEntry)enumTmp.nextElement();
                            hashEntries.put(tmpEntry.getId(), tmpEntry);
                        }
                    }
                    enumTmp = hashEntries.elements();
                    while (enumTmp.hasMoreElements()) {
                        tmpEntry = (AbstractDatabaseEntry)enumTmp.nextElement();
                        if (i == 0) {
                            AbstractDatabaseEntry idEntry = Database.getInstance(InfoServiceIDEntry.class).getEntryById(tmpEntry.getId());
                            if (tmpEntry.getId().equals(Configuration.getInstance().getID()) || !tmpEntry.isNewerThan(idEntry)) continue;
                            Database.getInstance(InfoServiceIDEntry.class).update(new InfoServiceIDEntry((InfoServiceDBEntry)tmpEntry));
                            Database.getInstance(InfoServiceDBEntry.class).update(tmpEntry, false);
                            continue;
                        }
                        if (i == 1) {
                            LogHolder.log(5, LogType.MISC, "Updating payment instances...");
                            if (!Database.getInstance(PaymentInstanceDBEntry.class).update(tmpEntry, false)) continue;
                            LogHolder.log(5, LogType.MISC, "Payment instances updated!");
                            continue;
                        }
                        if (i == 2) {
                            Database.getInstance(MixCascade.class).update(tmpEntry, false);
                            continue;
                        }
                        Database.getInstance(MixInfo.class).update(tmpEntry, false);
                    }
                }
                InfoServiceDBEntry generatedOwnEntry = new InfoServiceDBEntry(Configuration.getInstance().getOwnName(), Configuration.getInstance().getID(), virtualListeners, Configuration.getInstance().holdForwarderList(), false, System.currentTimeMillis(), ms_serialNumber, Configuration.getInstance().isPerfServerEnabled(), new ServiceSoftware("IS.09.010"));
                if (!Database.getInstance(InfoServiceDBEntry.class).update(generatedOwnEntry)) {
                    LogHolder.log(1, LogType.MISC, "Could not update own InfoService entry: " + generatedOwnEntry.getName() + ":" + generatedOwnEntry.getId() + ":LastUpdate:" + generatedOwnEntry.getLastUpdate() + ":VersionNumber:" + generatedOwnEntry.getVersionNumber());
                    ms_serialNumber = System.currentTimeMillis();
                }
                InfoServiceDistributor.getInstance().addJobToInititalNeighboursQueue(generatedOwnEntry);
                LogHolder.log(7, LogType.MISC, "Updating and propagating own InfoServerDBEntry.");
                if (bInit) {
                    bInit = false;
                    if (m_meter != null) {
                        m_meter.update();
                    }
                }
            } else {
                LogHolder.log(0, LogType.MISC, "There is no virtual listener interface configurated. Shutdown InfoService!");
                System.out.println("There is no virtual listener interface configurated. Shutdown InfoService!");
                System.exit(-1);
            }
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        alreadyRunning = false;
    }
}

