/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.client;

import anon.anonudp.UDPMultiplexer;
import anon.anonudp.mixchannel.Channel;
import anon.anonudp.mixchannel.IPv4AndPort;
import anon.anonudp.mixpacket.IPacket;
import anon.client.AbstractAnonUDPChannel;
import anon.client.UDPPacketStreamDesynchronisationException;
import anon.client.UDPPacketToLargeException;
import java.io.IOException;

public class AnonPureUDPChannel
extends AbstractAnonUDPChannel {
    private Channel underlyingChannel;
    private UDPMultiplexer multiplexer;
    private IPv4AndPort destination;
    private static final int READ_INTERVAL = 10;

    public AnonPureUDPChannel(UDPMultiplexer multiplexer) {
        this.multiplexer = multiplexer;
    }

    public void setDestination(String host, int port) {
        if (this.destination == null) {
            try {
                this.destination = new IPv4AndPort(host, port);
                this.underlyingChannel = new Channel(this.destination, this.multiplexer.getPublicKeys());
            }
            catch (IOException e) {
                throw new RuntimeException("Wasn't able to find IP-Address for given host: " + host);
            }
        } else {
            throw new RuntimeException("Destination was already set.");
        }
    }

    public void writePacket(byte[] payload, int offset, int length) throws IOException {
        if (length == payload.length && offset == 0) {
            this.writePacket(payload);
            return;
        }
        byte[] payloadPart = new byte[length];
        System.arraycopy(payload, offset, payloadPart, 0, length);
        this.writePacket(payloadPart);
    }

    public void writePacket(byte[] payload) throws IOException {
        IPacket[] packets;
        try {
            packets = this.underlyingChannel.request(payload);
        }
        catch (Exception e) {
            throw new IOException("Packet creation failed.");
        }
        for (int i = 0; i < packets.length; ++i) {
            try {
                this.multiplexer.sendToMix(packets[i]);
                continue;
            }
            catch (Exception e) {
                throw new IOException("Link encryption failed.");
            }
        }
    }

    public int readPacket(byte[] payload, int off, int len) throws IOException, UDPPacketStreamDesynchronisationException, UDPPacketToLargeException {
        while (!this.underlyingChannel.hasNext()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return -1;
            }
        }
        byte[] nextPacketPayload = this.underlyingChannel.next();
        if (nextPacketPayload.length > len) {
            throw new UDPPacketToLargeException();
        }
        System.arraycopy(nextPacketPayload, 0, payload, off, nextPacketPayload.length);
        return nextPacketPayload.length;
    }

    public int getOutputBlockSize() {
        return 277;
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }
}

